/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class SplashManager
extends SimplePreparableReloadListener<List<String>> {
    private static final ResourceLocation SPLASHES_LOCATION = new ResourceLocation("texts/splashes.txt");
    private static final Random RANDOM = new Random();
    private final List<String> splashes = Lists.newArrayList();
    private final User user;

    public SplashManager(User pUser) {
        this.user = pUser;
    }

    @Override
    protected List<String> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        try {
            List<String> list;
            try (Resource resource = Minecraft.getInstance().getResourceManager().getResource(SPLASHES_LOCATION);
                 BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
                list = bufferedreader.lines().map(String::trim).filter(p_118876_ -> p_118876_.hashCode() != 125780783).collect(Collectors.toList());
            }
            return list;
        }
        catch (IOException ioexception) {
            return Collections.emptyList();
        }
    }

    @Override
    protected void apply(List<String> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.splashes.clear();
        this.splashes.addAll(pObject);
    }

    @Nullable
    public String getSplash() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            return "Merry X-mas!";
        }
        if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            return "Happy new year!";
        }
        if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
            return "OOoooOOOoooo! Spooky!";
        }
        if (this.splashes.isEmpty()) {
            return null;
        }
        return this.user != null && RANDOM.nextInt(this.splashes.size()) == 42 ? String.valueOf(this.user.getName().toUpperCase(Locale.ROOT)) + " IS YOU" : this.splashes.get(RANDOM.nextInt(this.splashes.size()));
    }
}

