/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.language.FormattedBidiReorder;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.optifine.Lang;
import org.slf4j.Logger;

public class ClientLanguage
extends Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, String> storage;
    private final boolean defaultRightToLeft;

    private ClientLanguage(Map<String, String> pStorage, boolean pDefaultRightToLeft) {
        this.storage = pStorage;
        this.defaultRightToLeft = pDefaultRightToLeft;
    }

    public static ClientLanguage loadFrom(ResourceManager pResourceManager, List<LanguageInfo> pLanguageInfo) {
        HashMap map = Maps.newHashMap();
        boolean flag = false;
        for (LanguageInfo languageinfo : pLanguageInfo) {
            flag |= languageinfo.isBidirectional();
            String s = String.format("lang/%s.json", languageinfo.getCode());
            for (String s1 : pResourceManager.getNamespaces()) {
                try {
                    ResourceLocation resourcelocation = new ResourceLocation(s1, s);
                    ClientLanguage.appendFrom(pResourceManager.getResources(resourcelocation), map);
                    Lang.loadResources(pResourceManager, languageinfo.getCode(), (Map<String, String>)map);
                }
                catch (FileNotFoundException resourcelocation) {
                }
                catch (Exception exception1) {
                    LOGGER.warn("Skipped language file: {}:{} ({})", new Object[]{s1, s, exception1.toString()});
                }
            }
        }
        return new ClientLanguage((Map<String, String>)ImmutableMap.copyOf((Map)map), flag);
    }

    private static void appendFrom(List<Resource> pResources, Map<String, String> pDestinationMap) {
        for (Resource resource : pResources) {
            try (InputStream inputstream = resource.getInputStream();){
                Language.loadFromJson(inputstream, pDestinationMap::put);
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Failed to load translations from {}", (Object)resource, (Object)ioexception1);
            }
        }
    }

    @Override
    public String getOrDefault(String p_118920_) {
        return this.storage.getOrDefault(p_118920_, p_118920_);
    }

    @Override
    public boolean has(String p_118928_) {
        return this.storage.containsKey(p_118928_);
    }

    @Override
    public boolean isDefaultRightToLeft() {
        return this.defaultRightToLeft;
    }

    @Override
    public FormattedCharSequence getVisualOrder(FormattedText p_118925_) {
        return FormattedBidiReorder.reorder(p_118925_, this.defaultRightToLeft);
    }

    public Map<String, String> getLanguageData() {
        return this.storage;
    }
}

