/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.locale.Language;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.slf4j.Logger;

public class LanguageManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_LANGUAGE_CODE = "en_us";
    private static final LanguageInfo DEFAULT_LANGUAGE = new LanguageInfo("en_us", "US", "English", false);
    private Map<String, LanguageInfo> languages = ImmutableMap.of((Object)"en_us", (Object)DEFAULT_LANGUAGE);
    private String currentCode;
    private LanguageInfo currentLanguage = DEFAULT_LANGUAGE;

    public LanguageManager(String pCurrentCode) {
        this.currentCode = pCurrentCode;
    }

    private static Map<String, LanguageInfo> extractLanguages(Stream<PackResources> pPackResources) {
        HashMap map = Maps.newHashMap();
        pPackResources.forEach(p_118980_ -> {
            try {
                LanguageMetadataSection languagemetadatasection = p_118980_.getMetadataSection(LanguageMetadataSection.SERIALIZER);
                if (languagemetadatasection != null) {
                    for (LanguageInfo languageinfo : languagemetadatasection.getLanguages()) {
                        map.putIfAbsent(languageinfo.getCode(), languageinfo);
                    }
                }
            }
            catch (IOException | RuntimeException runtimeexception) {
                LOGGER.warn("Unable to parse language metadata section of resourcepack: {}", (Object)p_118980_.getName(), (Object)runtimeexception);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Override
    public void onResourceManagerReload(ResourceManager pResourceManager) {
        this.languages = LanguageManager.extractLanguages(pResourceManager.listPacks());
        LanguageInfo languageinfo = this.languages.getOrDefault(DEFAULT_LANGUAGE_CODE, DEFAULT_LANGUAGE);
        this.currentLanguage = this.languages.getOrDefault(this.currentCode, languageinfo);
        ArrayList list = Lists.newArrayList((Object[])new LanguageInfo[]{languageinfo});
        if (this.currentLanguage != languageinfo) {
            list.add(this.currentLanguage);
        }
        ClientLanguage clientlanguage = ClientLanguage.loadFrom(pResourceManager, list);
        I18n.setLanguage(clientlanguage);
        Language.inject(clientlanguage);
    }

    public void setSelected(LanguageInfo pCurrentLanguage) {
        this.currentCode = pCurrentLanguage.getCode();
        this.currentLanguage = pCurrentLanguage;
    }

    public LanguageInfo getSelected() {
        return this.currentLanguage;
    }

    public SortedSet<LanguageInfo> getLanguages() {
        return Sets.newTreeSet(this.languages.values());
    }

    public LanguageInfo getLanguage(String p_118977_) {
        return this.languages.get(p_118977_);
    }
}

