/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.animation;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSectionSerializer;

public class AnimationMetadataSection {
    public static final AnimationMetadataSectionSerializer SERIALIZER = new AnimationMetadataSectionSerializer();
    public static final String SECTION_NAME = "animation";
    public static final int DEFAULT_FRAME_TIME = 1;
    public static final int UNKNOWN_SIZE = -1;
    public static final AnimationMetadataSection EMPTY = new AnimationMetadataSection((List)Lists.newArrayList(), -1, -1, 1, false){

        @Override
        public Pair<Integer, Integer> getFrameSize(int p_119054_, int p_119055_) {
            return Pair.of((Object)p_119054_, (Object)p_119055_);
        }
    };
    private final List<AnimationFrame> frames;
    private int frameWidth;
    private int frameHeight;
    private final int defaultFrameTime;
    private final boolean interpolatedFrames;

    public AnimationMetadataSection(List<AnimationFrame> pFrames, int pFrameWidth, int pFrameHeight, int pDefaultFrameTime, boolean pInterpolatedFrames) {
        this.frames = pFrames;
        this.frameWidth = pFrameWidth;
        this.frameHeight = pFrameHeight;
        this.defaultFrameTime = pDefaultFrameTime;
        this.interpolatedFrames = pInterpolatedFrames;
    }

    private static boolean isDivisionInteger(int pValMul, int pVal) {
        return pValMul / pVal * pVal == pValMul;
    }

    public Pair<Integer, Integer> getFrameSize(int pWidth, int pHeight) {
        Pair<Integer, Integer> pair = this.calculateFrameSize(pWidth, pHeight);
        int i = (Integer)pair.getFirst();
        int j = (Integer)pair.getSecond();
        if (AnimationMetadataSection.isDivisionInteger(pWidth, i) && AnimationMetadataSection.isDivisionInteger(pHeight, j)) {
            return pair;
        }
        throw new IllegalArgumentException(String.format("Image size %s,%s is not multiply of frame size %s,%s", pWidth, pHeight, i, j));
    }

    private Pair<Integer, Integer> calculateFrameSize(int pDefWidth, int pDefHeight) {
        if (this.frameWidth != -1) {
            return this.frameHeight != -1 ? Pair.of((Object)this.frameWidth, (Object)this.frameHeight) : Pair.of((Object)this.frameWidth, (Object)pDefHeight);
        }
        if (this.frameHeight != -1) {
            return Pair.of((Object)pDefWidth, (Object)this.frameHeight);
        }
        int i = Math.min(pDefWidth, pDefHeight);
        return Pair.of((Object)i, (Object)i);
    }

    public int getFrameHeight(int pDefHeight) {
        return this.frameHeight == -1 ? pDefHeight : this.frameHeight;
    }

    public int getFrameWidth(int pDefWidth) {
        return this.frameWidth == -1 ? pDefWidth : this.frameWidth;
    }

    public int getDefaultFrameTime() {
        return this.defaultFrameTime;
    }

    public boolean isInterpolatedFrames() {
        return this.interpolatedFrames;
    }

    public void forEachFrame(FrameOutput p_174862_) {
        for (AnimationFrame animationframe : this.frames) {
            p_174862_.accept(animationframe.getIndex(), animationframe.getTime(this.defaultFrameTime));
        }
    }

    public List<AnimationFrame> getAnimationFrames() {
        return this.frames;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public void setFrameWidth(int frameWidth) {
        this.frameWidth = frameWidth;
    }

    public void setFrameHeight(int frameHeight) {
        this.frameHeight = frameHeight;
    }

    @FunctionalInterface
    public static interface FrameOutput {
        public void accept(int var1, int var2);
    }
}

