/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.animation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.Validate;

public class AnimationMetadataSectionSerializer
implements MetadataSectionSerializer<AnimationMetadataSection> {
    @Override
    public AnimationMetadataSection fromJson(JsonObject pJson) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = GsonHelper.getAsInt(pJson, "frametime", 1);
        if (i != 1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid default frame time");
        }
        if (pJson.has("frames")) {
            try {
                JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "frames");
                int j = 0;
                while (j < jsonarray.size()) {
                    JsonElement jsonelement = jsonarray.get(j);
                    AnimationFrame animationframe = this.getFrame(j, jsonelement);
                    if (animationframe != null) {
                        builder.add((Object)animationframe);
                    }
                    ++j;
                }
            }
            catch (ClassCastException classcastexception) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + pJson.get("frames"), (Throwable)classcastexception);
            }
        }
        int k = GsonHelper.getAsInt(pJson, "width", -1);
        int l = GsonHelper.getAsInt(pJson, "height", -1);
        if (k != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)k, (String)"Invalid width");
        }
        if (l != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)l, (String)"Invalid height");
        }
        boolean flag = GsonHelper.getAsBoolean(pJson, "interpolate", false);
        return new AnimationMetadataSection((List<AnimationFrame>)builder.build(), k, l, i, flag);
    }

    @Nullable
    private AnimationFrame getFrame(int pFrame, JsonElement pElement) {
        if (pElement.isJsonPrimitive()) {
            return new AnimationFrame(GsonHelper.convertToInt(pElement, "frames[" + pFrame + "]"));
        }
        if (pElement.isJsonObject()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(pElement, "frames[" + pFrame + "]");
            int i = GsonHelper.getAsInt(jsonobject, "time", -1);
            if (jsonobject.has("time")) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid frame time");
            }
            int j = GsonHelper.getAsInt(jsonobject, "index");
            Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)j, (String)"Invalid frame index");
            return new AnimationFrame(j, i);
        }
        return null;
    }

    @Override
    public String getMetadataSectionName() {
        return "animation";
    }
}

