/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.language;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;

public class LanguageMetadataSectionSerializer
implements MetadataSectionSerializer<LanguageMetadataSection> {
    private static final int MAX_LANGUAGE_LENGTH = 16;

    @Override
    public LanguageMetadataSection fromJson(JsonObject pJson) {
        HashSet set = Sets.newHashSet();
        for (Map.Entry entry : pJson.entrySet()) {
            String s = (String)entry.getKey();
            if (s.length() > 16) {
                throw new JsonParseException("Invalid language->'" + s + "': language code must not be more than 16 characters long");
            }
            JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), "language");
            String s1 = GsonHelper.getAsString(jsonobject, "region");
            String s2 = GsonHelper.getAsString(jsonobject, "name");
            boolean flag = GsonHelper.getAsBoolean(jsonobject, "bidirectional", false);
            if (s1.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + s + "'->region: empty value");
            }
            if (s2.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + s + "'->name: empty value");
            }
            if (set.add(new LanguageInfo(s, s1, s2, flag))) continue;
            throw new JsonParseException("Duplicate language->'" + s + "' defined");
        }
        return new LanguageMetadataSection(set);
    }

    @Override
    public String getMetadataSectionName() {
        return "language";
    }
}

