/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.util.Mth;

public enum BlockModelRotation implements ModelState
{
    X0_Y0(0, 0),
    X0_Y90(0, 90),
    X0_Y180(0, 180),
    X0_Y270(0, 270),
    X90_Y0(90, 0),
    X90_Y90(90, 90),
    X90_Y180(90, 180),
    X90_Y270(90, 270),
    X180_Y0(180, 0),
    X180_Y90(180, 90),
    X180_Y180(180, 180),
    X180_Y270(180, 270),
    X270_Y0(270, 0),
    X270_Y90(270, 90),
    X270_Y180(270, 180),
    X270_Y270(270, 270);

    private static final int DEGREES = 360;
    private static final Map<Integer, BlockModelRotation> BY_INDEX;
    private final Transformation transformation;
    private final OctahedralGroup actualRotation;
    private final int index;

    static {
        BY_INDEX = Arrays.stream(BlockModelRotation.values()).collect(Collectors.toMap(p_119163_ -> p_119163_.index, p_119157_ -> p_119157_));
    }

    private static int getIndex(int pX, int pY) {
        return pX * 360 + pY;
    }

    private BlockModelRotation(int p_119151_, int p_119152_) {
        this.index = BlockModelRotation.getIndex(p_119151_, p_119152_);
        Quaternion quaternion = Vector3f.YP.rotationDegrees(-p_119152_);
        quaternion.mul(Vector3f.XP.rotationDegrees(-p_119151_));
        OctahedralGroup octahedralgroup = OctahedralGroup.IDENTITY;
        int i = 0;
        while (i < p_119152_) {
            octahedralgroup = octahedralgroup.compose(OctahedralGroup.ROT_90_Y_NEG);
            i += 90;
        }
        int j = 0;
        while (j < p_119151_) {
            octahedralgroup = octahedralgroup.compose(OctahedralGroup.ROT_90_X_NEG);
            j += 90;
        }
        this.transformation = new Transformation(null, quaternion, null, null);
        this.actualRotation = octahedralgroup;
    }

    @Override
    public Transformation getRotation() {
        return this.transformation;
    }

    public static BlockModelRotation by(int pX, int pY) {
        return BY_INDEX.get(BlockModelRotation.getIndex(Mth.positiveModulo(pX, 360), Mth.positiveModulo(pY, 360)));
    }

    public OctahedralGroup actualRotation() {
        return this.actualRotation;
    }
}

