/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class ModelManager
extends SimplePreparableReloadListener<ModelBakery>
implements AutoCloseable {
    private Map<ResourceLocation, BakedModel> bakedRegistry;
    @Nullable
    private AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final TextureManager textureManager;
    private final BlockColors blockColors;
    private int maxMipmapLevels;
    private BakedModel missingModel;
    private Object2IntMap<BlockState> modelGroups;

    public ModelManager(TextureManager pTextureManager, BlockColors pBlockColors, int pMaxMipmapLevels) {
        this.textureManager = pTextureManager;
        this.blockColors = pBlockColors;
        this.maxMipmapLevels = pMaxMipmapLevels;
        this.blockModelShaper = new BlockModelShaper(this);
    }

    public BakedModel getModel(ModelResourceLocation pModelLocation) {
        return this.bakedRegistry.getOrDefault(pModelLocation, this.missingModel);
    }

    public BakedModel getMissingModel() {
        return this.missingModel;
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    @Override
    protected ModelBakery prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pProfiler.startTick();
        ModelBakery modelbakery = new ModelBakery(pResourceManager, this.blockColors, pProfiler, this.maxMipmapLevels);
        pProfiler.endTick();
        return modelbakery;
    }

    @Override
    protected void apply(ModelBakery pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pProfiler.startTick();
        pProfiler.push("upload");
        if (this.atlases != null) {
            this.atlases.close();
        }
        this.atlases = pObject.uploadTextures(this.textureManager, pProfiler);
        this.bakedRegistry = pObject.getBakedTopLevelModels();
        this.modelGroups = pObject.getModelGroups();
        this.missingModel = this.bakedRegistry.get(ModelBakery.MISSING_MODEL_LOCATION);
        pProfiler.popPush("cache");
        this.blockModelShaper.rebuildCache();
        pProfiler.pop();
        pProfiler.endTick();
    }

    public boolean requiresRender(BlockState pOldState, BlockState pNewState) {
        int j;
        if (pOldState == pNewState) {
            return false;
        }
        int i = this.modelGroups.getInt((Object)pOldState);
        if (i != -1 && i == (j = this.modelGroups.getInt((Object)pNewState))) {
            FluidState fluidstate1;
            FluidState fluidstate = pOldState.getFluidState();
            return fluidstate != (fluidstate1 = pNewState.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation pLocation) {
        return this.atlases.getAtlas(pLocation);
    }

    @Override
    public void close() {
        if (this.atlases != null) {
            this.atlases.close();
        }
    }

    public void updateMaxMipLevel(int pLevel) {
        this.maxMipmapLevels = pLevel;
    }
}

