/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartBakedModel
implements BakedModel {
    private final List<Pair<Predicate<BlockState>, BakedModel>> selectors;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    protected final ItemOverrides overrides;
    private final Map<BlockState, BitSet> selectorCache = new Object2ObjectOpenCustomHashMap(Util.identityStrategy());

    public MultiPartBakedModel(List<Pair<Predicate<BlockState>, BakedModel>> pSelectors) {
        this.selectors = pSelectors;
        BakedModel bakedmodel = (BakedModel)pSelectors.iterator().next().getRight();
        this.hasAmbientOcclusion = bakedmodel.useAmbientOcclusion();
        this.isGui3d = bakedmodel.isGui3d();
        this.usesBlockLight = bakedmodel.usesBlockLight();
        this.particleIcon = bakedmodel.getParticleIcon();
        this.transforms = bakedmodel.getTransforms();
        this.overrides = bakedmodel.getOverrides();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pSide, Random pRand) {
        if (pState == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.selectorCache.get(pState);
        if (bitset == null) {
            bitset = new BitSet();
            int i = 0;
            while (i < this.selectors.size()) {
                Pair<Predicate<BlockState>, BakedModel> pair = this.selectors.get(i);
                if (((Predicate)pair.getLeft()).test(pState)) {
                    bitset.set(i);
                }
                ++i;
            }
            this.selectorCache.put(pState, bitset);
        }
        ArrayList list = Lists.newArrayList();
        long k = pRand.nextLong();
        int j = 0;
        while (j < bitset.length()) {
            if (bitset.get(j)) {
                list.addAll(((BakedModel)this.selectors.get(j).getRight()).getQuads(pState, pSide, new Random(k)));
            }
            ++j;
        }
        return list;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    @Override
    public boolean isCustomRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @Override
    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public static class Builder {
        private final List<Pair<Predicate<BlockState>, BakedModel>> selectors = Lists.newArrayList();

        public void add(Predicate<BlockState> pPredicate, BakedModel pModel) {
            this.selectors.add((Pair<Predicate<BlockState>, BakedModel>)Pair.of(pPredicate, (Object)pModel));
        }

        public BakedModel build() {
            return new MultiPartBakedModel(this.selectors);
        }
    }
}

