/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Bee;

public abstract class BeeSoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 1.2f;
    private static final float PITCH_MIN = 0.0f;
    protected final Bee bee;
    private boolean hasSwitched;

    public BeeSoundInstance(Bee pBee, SoundEvent pSoundEvent, SoundSource pSource) {
        super(pSoundEvent, pSource);
        this.bee = pBee;
        this.x = (float)pBee.getX();
        this.y = (float)pBee.getY();
        this.z = (float)pBee.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    @Override
    public void tick() {
        boolean flag = this.shouldSwitchSounds();
        if (flag && !this.isStopped()) {
            Minecraft.getInstance().getSoundManager().queueTickingSound(this.getAlternativeSoundInstance());
            this.hasSwitched = true;
        }
        if (!this.bee.isRemoved() && !this.hasSwitched) {
            this.x = (float)this.bee.getX();
            this.y = (float)this.bee.getY();
            this.z = (float)this.bee.getZ();
            float f = (float)this.bee.getDeltaMovement().horizontalDistance();
            if (f >= 0.01f) {
                this.pitch = Mth.lerp(Mth.clamp(f, this.getMinPitch(), this.getMaxPitch()), this.getMinPitch(), this.getMaxPitch());
                this.volume = Mth.lerp(Mth.clamp(f, 0.0f, 0.5f), 0.0f, 1.2f);
            } else {
                this.pitch = 0.0f;
                this.volume = 0.0f;
            }
        } else {
            this.stop();
        }
    }

    private float getMinPitch() {
        return this.bee.isBaby() ? 1.1f : 0.7f;
    }

    private float getMaxPitch() {
        return this.bee.isBaby() ? 1.5f : 1.1f;
    }

    @Override
    public boolean canStartSilent() {
        return true;
    }

    @Override
    public boolean canPlaySound() {
        return !this.bee.isSilent();
    }

    protected abstract AbstractTickableSoundInstance getAlternativeSoundInstance();

    protected abstract boolean shouldSwitchSounds();
}

