/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.sounds;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.Validate;

public class SoundEventRegistrationSerializer
implements JsonDeserializer<SoundEventRegistration> {
    public SoundEventRegistration deserialize(JsonElement p_119827_, Type p_119828_, JsonDeserializationContext p_119829_) throws JsonParseException {
        JsonObject jsonobject = GsonHelper.convertToJsonObject(p_119827_, "entry");
        boolean flag = GsonHelper.getAsBoolean(jsonobject, "replace", false);
        String s = GsonHelper.getAsString(jsonobject, "subtitle", null);
        List<Sound> list = this.getSounds(jsonobject);
        return new SoundEventRegistration(list, flag, s);
    }

    private List<Sound> getSounds(JsonObject pObject) {
        ArrayList list = Lists.newArrayList();
        if (pObject.has("sounds")) {
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pObject, "sounds");
            int i = 0;
            while (i < jsonarray.size()) {
                JsonElement jsonelement = jsonarray.get(i);
                if (GsonHelper.isStringValue(jsonelement)) {
                    String s = GsonHelper.convertToString(jsonelement, "sound");
                    list.add(new Sound(s, 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16));
                } else {
                    list.add(this.getSound(GsonHelper.convertToJsonObject(jsonelement, "sound")));
                }
                ++i;
            }
        }
        return list;
    }

    private Sound getSound(JsonObject pObject) {
        String s = GsonHelper.getAsString(pObject, "name");
        Sound.Type sound$type = this.getType(pObject, Sound.Type.FILE);
        float f = GsonHelper.getAsFloat(pObject, "volume", 1.0f);
        Validate.isTrue((f > 0.0f ? 1 : 0) != 0, (String)"Invalid volume", (Object[])new Object[0]);
        float f1 = GsonHelper.getAsFloat(pObject, "pitch", 1.0f);
        Validate.isTrue((f1 > 0.0f ? 1 : 0) != 0, (String)"Invalid pitch", (Object[])new Object[0]);
        int i = GsonHelper.getAsInt(pObject, "weight", 1);
        Validate.isTrue((i > 0 ? 1 : 0) != 0, (String)"Invalid weight", (Object[])new Object[0]);
        boolean flag = GsonHelper.getAsBoolean(pObject, "preload", false);
        boolean flag1 = GsonHelper.getAsBoolean(pObject, "stream", false);
        int j = GsonHelper.getAsInt(pObject, "attenuation_distance", 16);
        return new Sound(s, f, f1, i, sound$type, flag1, flag, j);
    }

    private Sound.Type getType(JsonObject pObject, Sound.Type pDefaultValue) {
        Sound.Type sound$type = pDefaultValue;
        if (pObject.has("type")) {
            sound$type = Sound.Type.getByName(GsonHelper.getAsString(pObject, "type"));
            Validate.notNull((Object)((Object)sound$type), (String)"Invalid type", (Object[])new Object[0]);
        }
        return sound$type;
    }
}

