/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.searchtree;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;

public class SearchRegistry
implements ResourceManagerReloadListener {
    public static final Key<ItemStack> CREATIVE_NAMES = new Key();
    public static final Key<ItemStack> CREATIVE_TAGS = new Key();
    public static final Key<RecipeCollection> RECIPE_COLLECTIONS = new Key();
    private final Map<Key<?>, MutableSearchTree<?>> searchTrees = Maps.newHashMap();

    @Override
    public void onResourceManagerReload(ResourceManager pResourceManager) {
        for (MutableSearchTree<?> mutablesearchtree : this.searchTrees.values()) {
            mutablesearchtree.refresh();
        }
    }

    public <T> void register(Key<T> pKey, MutableSearchTree<T> pValue) {
        this.searchTrees.put(pKey, pValue);
    }

    public <T> MutableSearchTree<T> getTree(Key<T> pKey) {
        return this.searchTrees.get(pKey);
    }

    public static class Key<T> {
    }
}

