/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ChannelAccess {
    private final Set<ChannelHandle> channels = Sets.newIdentityHashSet();
    final Library library;
    final Executor executor;

    public ChannelAccess(Library pLibrary, Executor pExecutor) {
        this.library = pLibrary;
        this.executor = pExecutor;
    }

    public CompletableFuture<ChannelHandle> createHandle(Library.Pool pSystemMode) {
        CompletableFuture<ChannelHandle> completablefuture = new CompletableFuture<ChannelHandle>();
        this.executor.execute(() -> {
            Channel channel = this.library.acquireChannel(pSystemMode);
            if (channel != null) {
                ChannelHandle channelaccess$channelhandle = new ChannelHandle(channel);
                this.channels.add(channelaccess$channelhandle);
                completablefuture.complete(channelaccess$channelhandle);
            } else {
                completablefuture.complete(null);
            }
        });
        return completablefuture;
    }

    public void executeOnChannels(Consumer<Stream<Channel>> pSourceStreamConsumer) {
        this.executor.execute(() -> pSourceStreamConsumer.accept(this.channels.stream().map(p_174978_ -> p_174978_.channel).filter(Objects::nonNull)));
    }

    public void scheduleTick() {
        this.executor.execute(() -> {
            Iterator<ChannelHandle> iterator = this.channels.iterator();
            while (iterator.hasNext()) {
                ChannelHandle channelaccess$channelhandle = iterator.next();
                channelaccess$channelhandle.channel.updateStream();
                if (!channelaccess$channelhandle.channel.stopped()) continue;
                channelaccess$channelhandle.release();
                iterator.remove();
            }
        });
    }

    public void clear() {
        this.channels.forEach(ChannelHandle::release);
        this.channels.clear();
    }

    public class ChannelHandle {
        @Nullable
        Channel channel;
        private boolean stopped;

        public boolean isStopped() {
            return this.stopped;
        }

        public ChannelHandle(Channel p_120150_) {
            this.channel = p_120150_;
        }

        public void execute(Consumer<Channel> pSoundConsumer) {
            ChannelAccess.this.executor.execute(() -> {
                if (this.channel != null) {
                    pSoundConsumer.accept(this.channel);
                }
            });
        }

        public void release() {
            this.stopped = true;
            ChannelAccess.this.library.releaseChannel(this.channel);
            this.channel = null;
        }
    }
}

