/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;

public class LoopingAudioStream
implements AudioStream {
    private final AudioStreamProvider provider;
    private AudioStream stream;
    private final BufferedInputStream bufferedInputStream;

    public LoopingAudioStream(AudioStreamProvider pProvider, InputStream pInputStream) throws IOException {
        this.provider = pProvider;
        this.bufferedInputStream = new BufferedInputStream(pInputStream);
        this.bufferedInputStream.mark(Integer.MAX_VALUE);
        this.stream = pProvider.create(new NoCloseBuffer(this.bufferedInputStream));
    }

    @Override
    public AudioFormat getFormat() {
        return this.stream.getFormat();
    }

    @Override
    public ByteBuffer read(int pSize) throws IOException {
        ByteBuffer bytebuffer = this.stream.read(pSize);
        if (!bytebuffer.hasRemaining()) {
            this.stream.close();
            this.bufferedInputStream.reset();
            this.stream = this.provider.create(new NoCloseBuffer(this.bufferedInputStream));
            bytebuffer = this.stream.read(pSize);
        }
        return bytebuffer;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.bufferedInputStream.close();
    }

    @FunctionalInterface
    public static interface AudioStreamProvider {
        public AudioStream create(InputStream var1) throws IOException;
    }

    static class NoCloseBuffer
    extends FilterInputStream {
        NoCloseBuffer(InputStream pInputStream) {
            super(pInputStream);
        }

        @Override
        public void close() {
        }
    }
}

