/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.audio.OggAudioStream;
import com.mojang.blaze3d.audio.SoundBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class SoundBufferLibrary {
    private final ResourceManager resourceManager;
    private final Map<ResourceLocation, CompletableFuture<SoundBuffer>> cache = Maps.newHashMap();

    public SoundBufferLibrary(ResourceManager pResourceManager) {
        this.resourceManager = pResourceManager;
    }

    public CompletableFuture<SoundBuffer> getCompleteBuffer(ResourceLocation pSoundID) {
        return this.cache.computeIfAbsent(pSoundID, p_120208_ -> CompletableFuture.supplyAsync(() -> {
            try {
                SoundBuffer soundbuffer;
                try (Resource resource = this.resourceManager.getResource((ResourceLocation)p_120208_);
                     InputStream inputstream = resource.getInputStream();
                     OggAudioStream oggaudiostream = new OggAudioStream(inputstream);){
                    ByteBuffer bytebuffer = oggaudiostream.readAll();
                    soundbuffer = new SoundBuffer(bytebuffer, oggaudiostream.getFormat());
                }
                return soundbuffer;
            }
            catch (IOException ioexception) {
                throw new CompletionException(ioexception);
            }
        }, Util.backgroundExecutor()));
    }

    public CompletableFuture<AudioStream> getStream(ResourceLocation pResourceLocation, boolean pIsWrapper) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Resource resource = this.resourceManager.getResource(pResourceLocation);
                InputStream inputstream = resource.getInputStream();
                return pIsWrapper ? new LoopingAudioStream(OggAudioStream::new, inputstream) : new OggAudioStream(inputstream);
            }
            catch (IOException ioexception) {
                throw new CompletionException(ioexception);
            }
        }, Util.backgroundExecutor());
    }

    public void clear() {
        this.cache.values().forEach(p_120201_ -> p_120201_.thenAccept(SoundBuffer::discardAlBuffer));
        this.cache.clear();
    }

    public CompletableFuture<?> preload(Collection<Sound> pSounds) {
        return CompletableFuture.allOf((CompletableFuture[])pSounds.stream().map(p_120197_ -> this.getCompleteBuffer(p_120197_.getPath())).toArray(CompletableFuture[]::new));
    }
}

