/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Options;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.client.resources.sounds.SoundEventRegistrationSerializer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class SoundManager
extends SimplePreparableReloadListener<Preparations> {
    public static final Sound EMPTY_SOUND = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String SOUNDS_PATH = "sounds.json";
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Component.class, (Object)new Component.Serializer()).registerTypeAdapter(SoundEventRegistration.class, (Object)new SoundEventRegistrationSerializer()).create();
    private static final TypeToken<Map<String, SoundEventRegistration>> SOUND_EVENT_REGISTRATION_TYPE = new TypeToken<Map<String, SoundEventRegistration>>(){};
    private final Map<ResourceLocation, WeighedSoundEvents> registry = Maps.newHashMap();
    private final SoundEngine soundEngine;

    public SoundManager(ResourceManager pResourceManager, Options pOptions) {
        this.soundEngine = new SoundEngine(this, pOptions, pResourceManager);
    }

    @Override
    protected Preparations prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Preparations soundmanager$preparations = new Preparations();
        pProfiler.startTick();
        for (String s : pResourceManager.getNamespaces()) {
            pProfiler.push(s);
            try {
                for (Resource resource : pResourceManager.getResources(new ResourceLocation(s, SOUNDS_PATH))) {
                    pProfiler.push(resource.getSourceName());
                    try (InputStream inputstream = resource.getInputStream();
                         InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);){
                        pProfiler.push("parse");
                        Map<String, SoundEventRegistration> map = GsonHelper.fromJson(GSON, (Reader)reader, SOUND_EVENT_REGISTRATION_TYPE);
                        pProfiler.popPush("register");
                        for (Map.Entry<String, SoundEventRegistration> entry : map.entrySet()) {
                            soundmanager$preparations.handleRegistration(new ResourceLocation(s, entry.getKey()), entry.getValue(), pResourceManager);
                        }
                        pProfiler.pop();
                    }
                    catch (RuntimeException runtimeexception) {
                        LOGGER.warn("Invalid {} in resourcepack: '{}'", new Object[]{SOUNDS_PATH, resource.getSourceName(), runtimeexception});
                    }
                    pProfiler.pop();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pProfiler.pop();
        }
        pProfiler.endTick();
        return soundmanager$preparations;
    }

    @Override
    protected void apply(Preparations pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pObject.apply(this.registry, this.soundEngine);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            for (ResourceLocation resourcelocation : this.registry.keySet()) {
                String s;
                WeighedSoundEvents weighedsoundevents = this.registry.get(resourcelocation);
                if (!(weighedsoundevents.getSubtitle() instanceof TranslatableComponent) || I18n.exists(s = ((TranslatableComponent)weighedsoundevents.getSubtitle()).getKey()) || !Registry.SOUND_EVENT.containsKey(resourcelocation)) continue;
                LOGGER.error("Missing subtitle {} for sound event: {}", (Object)s, (Object)resourcelocation);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            for (ResourceLocation resourcelocation1 : this.registry.keySet()) {
                if (Registry.SOUND_EVENT.containsKey(resourcelocation1)) continue;
                LOGGER.debug("Not having sound event for: {}", (Object)resourcelocation1);
            }
        }
        this.soundEngine.reload();
    }

    public List<String> getAvailableSoundDevices() {
        return this.soundEngine.getAvailableSoundDevices();
    }

    static boolean validateSoundResource(Sound pSound, ResourceLocation pSoundLocation, ResourceManager pResourceManager) {
        ResourceLocation resourcelocation = pSound.getPath();
        if (!pResourceManager.hasResource(resourcelocation)) {
            LOGGER.warn("File {} does not exist, cannot add it to event {}", (Object)resourcelocation, (Object)pSoundLocation);
            return false;
        }
        return true;
    }

    @Nullable
    public WeighedSoundEvents getSoundEvent(ResourceLocation pLocation) {
        return this.registry.get(pLocation);
    }

    public Collection<ResourceLocation> getAvailableSounds() {
        return this.registry.keySet();
    }

    public void queueTickingSound(TickableSoundInstance pTickableSound) {
        this.soundEngine.queueTickingSound(pTickableSound);
    }

    public void play(SoundInstance pSound) {
        this.soundEngine.play(pSound);
    }

    public void playDelayed(SoundInstance pSound, int pDelay) {
        this.soundEngine.playDelayed(pSound, pDelay);
    }

    public void updateSource(Camera pActiveRenderInfo) {
        this.soundEngine.updateSource(pActiveRenderInfo);
    }

    public void pause() {
        this.soundEngine.pause();
    }

    public void stop() {
        this.soundEngine.stopAll();
    }

    public void destroy() {
        this.soundEngine.destroy();
    }

    public void tick(boolean pIsGamePaused) {
        this.soundEngine.tick(pIsGamePaused);
    }

    public void resume() {
        this.soundEngine.resume();
    }

    public void updateSourceVolume(SoundSource pCategory, float pVolume) {
        if (pCategory == SoundSource.MASTER && pVolume <= 0.0f) {
            this.stop();
        }
        this.soundEngine.updateCategoryVolume(pCategory, pVolume);
    }

    public void stop(SoundInstance pSound) {
        this.soundEngine.stop(pSound);
    }

    public boolean isActive(SoundInstance pSound) {
        return this.soundEngine.isActive(pSound);
    }

    public void addListener(SoundEventListener pListener) {
        this.soundEngine.addEventListener(pListener);
    }

    public void removeListener(SoundEventListener pListener) {
        this.soundEngine.removeEventListener(pListener);
    }

    public void stop(@Nullable ResourceLocation pId, @Nullable SoundSource pCategory) {
        this.soundEngine.stop(pId, pCategory);
    }

    public String getDebugString() {
        return this.soundEngine.getDebugString();
    }

    public void reload() {
        this.soundEngine.reload();
    }

    protected static class Preparations {
        final Map<ResourceLocation, WeighedSoundEvents> registry = Maps.newHashMap();

        protected Preparations() {
        }

        void handleRegistration(ResourceLocation pSoundLocation, SoundEventRegistration pSoundList, ResourceManager pResourceManager) {
            boolean flag;
            WeighedSoundEvents weighedsoundevents = this.registry.get(pSoundLocation);
            boolean bl = flag = weighedsoundevents == null;
            if (flag || pSoundList.isReplace()) {
                if (!flag) {
                    LOGGER.debug("Replaced sound event location {}", (Object)pSoundLocation);
                }
                weighedsoundevents = new WeighedSoundEvents(pSoundLocation, pSoundList.getSubtitle());
                this.registry.put(pSoundLocation, weighedsoundevents);
            }
            block4: for (final Sound sound : pSoundList.getSounds()) {
                final ResourceLocation resourcelocation = sound.getLocation();
                weighedsoundevents.addSound(switch (sound.getType()) {
                    case Sound.Type.FILE -> {
                        if (!SoundManager.validateSoundResource(sound, pSoundLocation, pResourceManager)) continue block4;
                        yield sound;
                    }
                    case Sound.Type.SOUND_EVENT -> new Weighted<Sound>(){

                        @Override
                        public int getWeight() {
                            WeighedSoundEvents weighedsoundevents1 = registry.get(resourcelocation);
                            return weighedsoundevents1 == null ? 0 : weighedsoundevents1.getWeight();
                        }

                        @Override
                        public Sound getSound() {
                            WeighedSoundEvents weighedsoundevents1 = registry.get(resourcelocation);
                            if (weighedsoundevents1 == null) {
                                return EMPTY_SOUND;
                            }
                            Sound sound1 = weighedsoundevents1.getSound();
                            return new Sound(sound1.getLocation().toString(), sound1.getVolume() * sound.getVolume(), sound1.getPitch() * sound.getPitch(), sound.getWeight(), Sound.Type.FILE, sound1.shouldStream() || sound.shouldStream(), sound1.shouldPreload(), sound1.getAttenuationDistance());
                        }

                        @Override
                        public void preloadIfRequired(SoundEngine p_120438_) {
                            WeighedSoundEvents weighedsoundevents1 = registry.get(resourcelocation);
                            if (weighedsoundevents1 != null) {
                                weighedsoundevents1.preloadIfRequired(p_120438_);
                            }
                        }
                    };
                    default -> throw new IllegalStateException("Unknown SoundEventRegistration type: " + (Object)((Object)sound.getType()));
                });
            }
        }

        public void apply(Map<ResourceLocation, WeighedSoundEvents> pSoundRegistry, SoundEngine pSoundManager) {
            pSoundRegistry.clear();
            for (Map.Entry<ResourceLocation, WeighedSoundEvents> entry : this.registry.entrySet()) {
                pSoundRegistry.put(entry.getKey(), entry.getValue());
                entry.getValue().preloadIfRequired(pSoundManager);
            }
        }
    }
}

