/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.tutorial;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.Input;
import net.minecraft.client.tutorial.BundleTutorial;
import net.minecraft.client.tutorial.TutorialStepInstance;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class Tutorial {
    private final Minecraft minecraft;
    @Nullable
    private TutorialStepInstance instance;
    private final List<TimedToast> timedToasts = Lists.newArrayList();
    private final BundleTutorial bundleTutorial;

    public Tutorial(Minecraft pMinecraft, Options pOptions) {
        this.minecraft = pMinecraft;
        this.bundleTutorial = new BundleTutorial(this, pOptions);
    }

    public void onInput(Input pInput) {
        if (this.instance != null) {
            this.instance.onInput(pInput);
        }
    }

    public void onMouse(double pVelocityX, double p_120567_) {
        if (this.instance != null) {
            this.instance.onMouse(pVelocityX, p_120567_);
        }
    }

    public void onLookAt(@Nullable ClientLevel pLevel, @Nullable HitResult pResult) {
        if (this.instance != null && pResult != null && pLevel != null) {
            this.instance.onLookAt(pLevel, pResult);
        }
    }

    public void onDestroyBlock(ClientLevel pLevel, BlockPos pPos, BlockState pState, float pDiggingStage) {
        if (this.instance != null) {
            this.instance.onDestroyBlock(pLevel, pPos, pState, pDiggingStage);
        }
    }

    public void onOpenInventory() {
        if (this.instance != null) {
            this.instance.onOpenInventory();
        }
    }

    public void onGetItem(ItemStack pStack) {
        if (this.instance != null) {
            this.instance.onGetItem(pStack);
        }
    }

    public void stop() {
        if (this.instance != null) {
            this.instance.clear();
            this.instance = null;
        }
    }

    public void start() {
        if (this.instance != null) {
            this.stop();
        }
        this.instance = this.minecraft.options.tutorialStep.create(this);
    }

    public void addTimedToast(TutorialToast pToast, int pDurationTicks) {
        this.timedToasts.add(new TimedToast(pToast, pDurationTicks));
        this.minecraft.getToasts().addToast(pToast);
    }

    public void removeTimedToast(TutorialToast pToast) {
        this.timedToasts.removeIf(p_120577_ -> p_120577_.toast == pToast);
        pToast.hide();
    }

    public void tick() {
        this.timedToasts.removeIf(TimedToast::access$0);
        if (this.instance != null) {
            if (this.minecraft.level != null) {
                this.instance.tick();
            } else {
                this.stop();
            }
        } else if (this.minecraft.level != null) {
            this.start();
        }
    }

    public void setStep(TutorialSteps pStep) {
        this.minecraft.options.tutorialStep = pStep;
        this.minecraft.options.save();
        if (this.instance != null) {
            this.instance.clear();
            this.instance = pStep.create(this);
        }
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public boolean isSurvival() {
        if (this.minecraft.gameMode == null) {
            return false;
        }
        return this.minecraft.gameMode.getPlayerMode() == GameType.SURVIVAL;
    }

    public static Component key(String pKeybind) {
        return new KeybindComponent("key." + pKeybind).withStyle(ChatFormatting.BOLD);
    }

    public void onInventoryAction(ItemStack p_175025_, ItemStack p_175026_, ClickAction p_175027_) {
        this.bundleTutorial.onInventoryAction(p_175025_, p_175026_, p_175027_);
    }

    static final class TimedToast {
        final TutorialToast toast;
        private final int durationTicks;
        private int progress;

        TimedToast(TutorialToast pToast, int pDurationTicks) {
            this.toast = pToast;
            this.durationTicks = pDurationTicks;
        }

        private boolean updateProgress() {
            this.toast.updateProgress(Math.min((float)(++this.progress) / (float)this.durationTicks, 1.0f));
            if (this.progress > this.durationTicks) {
                this.toast.hide();
                return true;
            }
            return false;
        }

        static /* synthetic */ boolean access$0(TimedToast timedToast) {
            return timedToast.updateProgress();
        }
    }
}

