/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public interface SharedSuggestionProvider {
    public Collection<String> getOnlinePlayerNames();

    default public Collection<String> getSelectedEntities() {
        return Collections.emptyList();
    }

    public Collection<String> getAllTeams();

    public Collection<ResourceLocation> getAvailableSoundEvents();

    public Stream<ResourceLocation> getRecipeNames();

    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> var1);

    default public Collection<TextCoordinates> getRelevantCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    default public Collection<TextCoordinates> getAbsoluteCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    public Set<ResourceKey<Level>> levels();

    public RegistryAccess registryAccess();

    default public void suggestRegistryElements(Registry<?> p_212336_, ElementSuggestionType p_212337_, SuggestionsBuilder p_212338_) {
        if (p_212337_.shouldSuggestTags()) {
            SharedSuggestionProvider.suggestResource(p_212336_.getTagNames().map(TagKey::location), p_212338_, "#");
        }
        if (p_212337_.shouldSuggestElements()) {
            SharedSuggestionProvider.suggestResource(p_212336_.keySet(), p_212338_);
        }
    }

    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> var1, ElementSuggestionType var2, SuggestionsBuilder var3, CommandContext<?> var4);

    public boolean hasPermission(int var1);

    public static <T> void filterResources(Iterable<T> pResources, String pInput, Function<T, ResourceLocation> pLocationFunction, Consumer<T> pResourceConsumer) {
        boolean flag = pInput.indexOf(58) > -1;
        for (T t : pResources) {
            ResourceLocation resourcelocation = pLocationFunction.apply(t);
            if (flag) {
                String s = resourcelocation.toString();
                if (!SharedSuggestionProvider.matchesSubStr(pInput, s)) continue;
                pResourceConsumer.accept(t);
                continue;
            }
            if (!SharedSuggestionProvider.matchesSubStr(pInput, resourcelocation.getNamespace()) && (!resourcelocation.getNamespace().equals("minecraft") || !SharedSuggestionProvider.matchesSubStr(pInput, resourcelocation.getPath()))) continue;
            pResourceConsumer.accept(t);
        }
    }

    public static <T> void filterResources(Iterable<T> pResources, String pRemaining, String pPrefix, Function<T, ResourceLocation> pLocationFunction, Consumer<T> pResourceConsumer) {
        if (pRemaining.isEmpty()) {
            pResources.forEach(pResourceConsumer);
        } else {
            String s = Strings.commonPrefix((CharSequence)pRemaining, (CharSequence)pPrefix);
            if (!s.isEmpty()) {
                String s1 = pRemaining.substring(s.length());
                SharedSuggestionProvider.filterResources(pResources, s1, pLocationFunction, pResourceConsumer);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> pResources, SuggestionsBuilder pBuilder, String pPrefix) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(pResources, s, pPrefix, p_82985_ -> p_82985_, p_82917_ -> pBuilder.suggest(String.valueOf(pPrefix) + p_82917_));
        return pBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> pResources, SuggestionsBuilder pBuilder, String pPrefix) {
        return SharedSuggestionProvider.suggestResource(pResources::iterator, pBuilder, pPrefix);
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> pResources, SuggestionsBuilder pBuilder) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(pResources, s, p_82966_ -> p_82966_, p_82925_ -> pBuilder.suggest(p_82925_.toString()));
        return pBuilder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Iterable<T> pResources, SuggestionsBuilder pBuilder, Function<T, ResourceLocation> pLocationFunction, Function<T, Message> pSuggestionFunction) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(pResources, s, pLocationFunction, p_82922_ -> pBuilder.suggest(((ResourceLocation)pLocationFunction.apply(p_82922_)).toString(), (Message)pSuggestionFunction.apply(p_82922_)));
        return pBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> pResources, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.suggestResource(pResources::iterator, pBuilder);
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Stream<T> pResources, SuggestionsBuilder pBuilder, Function<T, ResourceLocation> pLocationFunction, Function<T, Message> pSuggestionFunction) {
        return SharedSuggestionProvider.suggestResource(pResources::iterator, pBuilder, pLocationFunction, pSuggestionFunction);
    }

    public static CompletableFuture<Suggestions> suggestCoordinates(String pRemaining, Collection<TextCoordinates> pCoordinates, SuggestionsBuilder pBuilder, Predicate<String> pVaidator) {
        ArrayList list;
        block4: {
            String[] astring;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)pRemaining)) break block3;
                    for (TextCoordinates sharedsuggestionprovider$textcoordinates : pCoordinates) {
                        String s = String.valueOf(sharedsuggestionprovider$textcoordinates.x) + " " + sharedsuggestionprovider$textcoordinates.y + " " + sharedsuggestionprovider$textcoordinates.z;
                        if (!pVaidator.test(s)) continue;
                        list.add(sharedsuggestionprovider$textcoordinates.x);
                        list.add(String.valueOf(sharedsuggestionprovider$textcoordinates.x) + " " + sharedsuggestionprovider$textcoordinates.y);
                        list.add(s);
                    }
                    break block4;
                }
                astring = pRemaining.split(" ");
                if (astring.length != 1) break block5;
                for (TextCoordinates sharedsuggestionprovider$textcoordinates1 : pCoordinates) {
                    String s1 = String.valueOf(astring[0]) + " " + sharedsuggestionprovider$textcoordinates1.y + " " + sharedsuggestionprovider$textcoordinates1.z;
                    if (!pVaidator.test(s1)) continue;
                    list.add(String.valueOf(astring[0]) + " " + sharedsuggestionprovider$textcoordinates1.y);
                    list.add(s1);
                }
                break block4;
            }
            if (astring.length != 2) break block4;
            for (TextCoordinates sharedsuggestionprovider$textcoordinates2 : pCoordinates) {
                String s2 = String.valueOf(astring[0]) + " " + astring[1] + " " + sharedsuggestionprovider$textcoordinates2.z;
                if (!pVaidator.test(s2)) continue;
                list.add(s2);
            }
        }
        return SharedSuggestionProvider.suggest(list, pBuilder);
    }

    public static CompletableFuture<Suggestions> suggest2DCoordinates(String pRemaining, Collection<TextCoordinates> pCoordinates, SuggestionsBuilder pBuilder, Predicate<String> pValidator) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)pRemaining)) break block2;
                for (TextCoordinates sharedsuggestionprovider$textcoordinates : pCoordinates) {
                    String s = String.valueOf(sharedsuggestionprovider$textcoordinates.x) + " " + sharedsuggestionprovider$textcoordinates.z;
                    if (!pValidator.test(s)) continue;
                    list.add(sharedsuggestionprovider$textcoordinates.x);
                    list.add(s);
                }
                break block3;
            }
            String[] astring = pRemaining.split(" ");
            if (astring.length != 1) break block3;
            for (TextCoordinates sharedsuggestionprovider$textcoordinates1 : pCoordinates) {
                String s1 = String.valueOf(astring[0]) + " " + sharedsuggestionprovider$textcoordinates1.z;
                if (!pValidator.test(s1)) continue;
                list.add(s1);
            }
        }
        return SharedSuggestionProvider.suggest(list, pBuilder);
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> pStrings, SuggestionsBuilder pBuilder) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String s1 : pStrings) {
            if (!SharedSuggestionProvider.matchesSubStr(s, s1.toLowerCase(Locale.ROOT))) continue;
            pBuilder.suggest(s1);
        }
        return pBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Stream<String> pStrings, SuggestionsBuilder pBuilder) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        pStrings.filter(p_82975_ -> SharedSuggestionProvider.matchesSubStr(s, p_82975_.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)pBuilder).suggest(arg_0));
        return pBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(String[] p_82968_, SuggestionsBuilder p_82969_) {
        String s = p_82969_.getRemaining().toLowerCase(Locale.ROOT);
        String[] stringArray = p_82968_;
        int n = p_82968_.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            if (SharedSuggestionProvider.matchesSubStr(s, s1.toLowerCase(Locale.ROOT))) {
                p_82969_.suggest(s1);
            }
            ++n2;
        }
        return p_82969_.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggest(Iterable<T> pResources, SuggestionsBuilder pBuilder, Function<T, String> pStringFunction, Function<T, Message> pSuggestionFunction) {
        String s = pBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (T t : pResources) {
            String s1 = pStringFunction.apply(t);
            if (!SharedSuggestionProvider.matchesSubStr(s, s1.toLowerCase(Locale.ROOT))) continue;
            pBuilder.suggest(s1, pSuggestionFunction.apply(t));
        }
        return pBuilder.buildFuture();
    }

    public static boolean matchesSubStr(String pInput, String pSubstring) {
        int i = 0;
        while (!pSubstring.startsWith(pInput, i)) {
            if ((i = pSubstring.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static enum ElementSuggestionType {
        TAGS,
        ELEMENTS,
        ALL;


        public boolean shouldSuggestTags() {
            return this == TAGS || this == ALL;
        }

        public boolean shouldSuggestElements() {
            return this == ELEMENTS || this == ALL;
        }
    }

    public static class TextCoordinates {
        public static final TextCoordinates DEFAULT_LOCAL = new TextCoordinates("^", "^", "^");
        public static final TextCoordinates DEFAULT_GLOBAL = new TextCoordinates("~", "~", "~");
        public final String x;
        public final String y;
        public final String z;

        public TextCoordinates(String pX, String pY, String pZ) {
            this.x = pX;
            this.y = pY;
            this.z = pZ;
        }
    }
}

