/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityAnchorArgument
implements ArgumentType<Anchor> {
    private static final Collection<String> EXAMPLES = Arrays.asList("eyes", "feet");
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(p_90357_ -> new TranslatableComponent("argument.anchor.invalid", p_90357_));

    public static Anchor getAnchor(CommandContext<CommandSourceStack> pContext, String pName) {
        return (Anchor)((Object)pContext.getArgument(pName, Anchor.class));
    }

    public static EntityAnchorArgument anchor() {
        return new EntityAnchorArgument();
    }

    public Anchor parse(StringReader p_90352_) throws CommandSyntaxException {
        int i = p_90352_.getCursor();
        String s = p_90352_.readUnquotedString();
        Anchor entityanchorargument$anchor = Anchor.getByName(s);
        if (entityanchorargument$anchor == null) {
            p_90352_.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)p_90352_, (Object)s);
        }
        return entityanchorargument$anchor;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.suggest(Anchor.BY_NAME.keySet(), pBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static enum Anchor {
        FEET("feet", (p_90389_, p_90390_) -> p_90389_),
        EYES("eyes", (p_90382_, p_90383_) -> new Vec3(p_90382_.x, p_90382_.y + (double)p_90383_.getEyeHeight(), p_90382_.z));

        static final Map<String, Anchor> BY_NAME;
        private final String name;
        private final BiFunction<Vec3, Entity, Vec3> transform;

        static {
            BY_NAME = Util.make(Maps.newHashMap(), p_90387_ -> {
                Anchor[] anchorArray = Anchor.values();
                int n = anchorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Anchor entityanchorargument$anchor = anchorArray[n2];
                    p_90387_.put(entityanchorargument$anchor.name, entityanchorargument$anchor);
                    ++n2;
                }
            });
        }

        private Anchor(String p_90374_, BiFunction<Vec3, Entity, Vec3> p_90375_) {
            this.name = p_90374_;
            this.transform = p_90375_;
        }

        @Nullable
        public static Anchor getByName(String pName) {
            return BY_NAME.get(pName);
        }

        public Vec3 apply(Entity pSource) {
            return this.transform.apply(pSource.position(), pSource);
        }

        public Vec3 apply(CommandSourceStack pSource) {
            Entity entity = pSource.getEntity();
            return entity == null ? pSource.getPosition() : this.transform.apply(pSource.getPosition(), entity);
        }
    }
}

