/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public class GameProfileArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");
    public static final SimpleCommandExceptionType ERROR_UNKNOWN_PLAYER = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.player.unknown"));

    public static Collection<GameProfile> getGameProfiles(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return ((Result)pContext.getArgument(pName, Result.class)).getNames((CommandSourceStack)pContext.getSource());
    }

    public static GameProfileArgument gameProfile() {
        return new GameProfileArgument();
    }

    public Result parse(StringReader pReader) throws CommandSyntaxException {
        if (pReader.canRead() && pReader.peek() == '@') {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(pReader);
            EntitySelector entityselector = entityselectorparser.parse();
            if (entityselector.includesEntities()) {
                throw EntityArgument.ERROR_ONLY_PLAYERS_ALLOWED.create();
            }
            return new SelectorResult(entityselector);
        }
        int i = pReader.getCursor();
        while (pReader.canRead() && pReader.peek() != ' ') {
            pReader.skip();
        }
        String s = pReader.getString().substring(i, pReader.getCursor());
        return p_94595_ -> {
            Optional<GameProfile> optional = p_94595_.getServer().getProfileCache().get(s);
            return Collections.singleton(optional.orElseThrow(() -> ((SimpleCommandExceptionType)ERROR_UNKNOWN_PLAYER).create()));
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        if (pContext.getSource() instanceof SharedSuggestionProvider) {
            StringReader stringreader = new StringReader(pBuilder.getInput());
            stringreader.setCursor(pBuilder.getStart());
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader);
            try {
                entityselectorparser.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entityselectorparser.fillSuggestions(pBuilder, p_94589_ -> SharedSuggestionProvider.suggest(((SharedSuggestionProvider)pContext.getSource()).getOnlinePlayerNames(), p_94589_));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface Result {
        public Collection<GameProfile> getNames(CommandSourceStack var1) throws CommandSyntaxException;
    }

    public static class SelectorResult
    implements Result {
        private final EntitySelector selector;

        public SelectorResult(EntitySelector pSelector) {
            this.selector = pSelector;
        }

        @Override
        public Collection<GameProfile> getNames(CommandSourceStack pSource) throws CommandSyntaxException {
            List<ServerPlayer> list = this.selector.findPlayers(pSource);
            if (list.isEmpty()) {
                throw EntityArgument.NO_PLAYERS_FOUND.create();
            }
            ArrayList list1 = Lists.newArrayList();
            for (ServerPlayer serverplayer : list) {
                list1.add(serverplayer.getGameProfile());
            }
            return list1;
        }
    }
}

