/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class MessageArgument
implements ArgumentType<Message> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");

    public static MessageArgument message() {
        return new MessageArgument();
    }

    public static Component getMessage(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return ((Message)pContext.getArgument(pName, Message.class)).toComponent((CommandSourceStack)pContext.getSource(), ((CommandSourceStack)pContext.getSource()).hasPermission(2));
    }

    public Message parse(StringReader pReader) throws CommandSyntaxException {
        return Message.parseText(pReader, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Message {
        private final String text;
        private final Part[] parts;

        public Message(String pText, Part[] pParts) {
            this.text = pText;
            this.parts = pParts;
        }

        public String getText() {
            return this.text;
        }

        public Part[] getParts() {
            return this.parts;
        }

        public Component toComponent(CommandSourceStack pSource, boolean pAllowSelectors) throws CommandSyntaxException {
            if (this.parts.length != 0 && pAllowSelectors) {
                TextComponent mutablecomponent = new TextComponent(this.text.substring(0, this.parts[0].getStart()));
                int i = this.parts[0].getStart();
                Part[] partArray = this.parts;
                int n = this.parts.length;
                int n2 = 0;
                while (n2 < n) {
                    Part messageargument$part = partArray[n2];
                    Component component = messageargument$part.toComponent(pSource);
                    if (i < messageargument$part.getStart()) {
                        mutablecomponent.append(this.text.substring(i, messageargument$part.getStart()));
                    }
                    if (component != null) {
                        mutablecomponent.append(component);
                    }
                    i = messageargument$part.getEnd();
                    ++n2;
                }
                if (i < this.text.length()) {
                    mutablecomponent.append(this.text.substring(i));
                }
                return mutablecomponent;
            }
            return new TextComponent(this.text);
        }

        public static Message parseText(StringReader pReader, boolean pAllowSelectors) throws CommandSyntaxException {
            String s = pReader.getString().substring(pReader.getCursor(), pReader.getTotalLength());
            if (!pAllowSelectors) {
                pReader.setCursor(pReader.getTotalLength());
                return new Message(s, new Part[0]);
            }
            ArrayList list = Lists.newArrayList();
            int i = pReader.getCursor();
            while (true) {
                EntitySelector entityselector;
                int j;
                block7: {
                    if (!pReader.canRead()) {
                        return new Message(s, list.toArray(new Part[0]));
                    }
                    if (pReader.peek() == '@') {
                        j = pReader.getCursor();
                        try {
                            EntitySelectorParser entityselectorparser = new EntitySelectorParser(pReader);
                            entityselector = entityselectorparser.parse();
                            break block7;
                        }
                        catch (CommandSyntaxException commandsyntaxexception) {
                            if (commandsyntaxexception.getType() != EntitySelectorParser.ERROR_MISSING_SELECTOR_TYPE && commandsyntaxexception.getType() != EntitySelectorParser.ERROR_UNKNOWN_SELECTOR_TYPE) {
                                throw commandsyntaxexception;
                            }
                            pReader.setCursor(j + 1);
                            continue;
                        }
                    }
                    pReader.skip();
                    continue;
                }
                list.add(new Part(j - i, pReader.getCursor() - i, entityselector));
            }
        }
    }

    public static class Part {
        private final int start;
        private final int end;
        private final EntitySelector selector;

        public Part(int pStart, int pEnd, EntitySelector pSelector) {
            this.start = pStart;
            this.end = pEnd;
            this.selector = pSelector;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public EntitySelector getSelector() {
            return this.selector;
        }

        @Nullable
        public Component toComponent(CommandSourceStack pSource) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(pSource));
        }
    }
}

