/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NbtPathArgument
implements ArgumentType<NbtPath> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType ERROR_INVALID_NODE = new SimpleCommandExceptionType((Message)new TranslatableComponent("arguments.nbtpath.node.invalid"));
    public static final DynamicCommandExceptionType ERROR_NOTHING_FOUND = new DynamicCommandExceptionType(p_99502_ -> new TranslatableComponent("arguments.nbtpath.nothing_found", p_99502_));
    private static final char INDEX_MATCH_START = '[';
    private static final char INDEX_MATCH_END = ']';
    private static final char KEY_MATCH_START = '{';
    private static final char KEY_MATCH_END = '}';
    private static final char QUOTED_KEY_START = '\"';

    public static NbtPathArgument nbtPath() {
        return new NbtPathArgument();
    }

    public static NbtPath getPath(CommandContext<CommandSourceStack> pContext, String pName) {
        return (NbtPath)pContext.getArgument(pName, NbtPath.class);
    }

    public NbtPath parse(StringReader pReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int i = pReader.getCursor();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        boolean flag = true;
        while (pReader.canRead() && pReader.peek() != ' ') {
            char c0;
            Node nbtpathargument$node = NbtPathArgument.parseNode(pReader, flag);
            list.add(nbtpathargument$node);
            object2intmap.put((Object)nbtpathargument$node, pReader.getCursor() - i);
            flag = false;
            if (!pReader.canRead() || (c0 = pReader.peek()) == ' ' || c0 == '[' || c0 == '{') continue;
            pReader.expect('.');
        }
        return new NbtPath(pReader.getString().substring(i, pReader.getCursor()), list.toArray(new Node[0]), (Object2IntMap<Node>)object2intmap);
    }

    private static Node parseNode(StringReader pReader, boolean pFirst) throws CommandSyntaxException {
        switch (pReader.peek()) {
            case '\"': {
                String s = pReader.readString();
                return NbtPathArgument.readObjectNode(pReader, s);
            }
            case '[': {
                pReader.skip();
                char j = pReader.peek();
                if (j == '{') {
                    CompoundTag compoundtag1 = new TagParser(pReader).readStruct();
                    pReader.expect(']');
                    return new MatchElementNode(compoundtag1);
                }
                if (j == ']') {
                    pReader.skip();
                    return AllElementsNode.INSTANCE;
                }
                int i = pReader.readInt();
                pReader.expect(']');
                return new IndexedElementNode(i);
            }
            case '{': {
                if (!pFirst) {
                    throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)pReader);
                }
                CompoundTag compoundtag = new TagParser(pReader).readStruct();
                return new MatchRootObjectNode(compoundtag);
            }
        }
        String s1 = NbtPathArgument.readUnquotedName(pReader);
        return NbtPathArgument.readObjectNode(pReader, s1);
    }

    private static Node readObjectNode(StringReader pReader, String pName) throws CommandSyntaxException {
        if (pReader.canRead() && pReader.peek() == '{') {
            CompoundTag compoundtag = new TagParser(pReader).readStruct();
            return new MatchObjectNode(pName, compoundtag);
        }
        return new CompoundChildNode(pName);
    }

    private static String readUnquotedName(StringReader pReader) throws CommandSyntaxException {
        int i = pReader.getCursor();
        while (pReader.canRead() && NbtPathArgument.isAllowedInUnquotedName(pReader.peek())) {
            pReader.skip();
        }
        if (pReader.getCursor() == i) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)pReader);
        }
        return pReader.getString().substring(i, pReader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isAllowedInUnquotedName(char pCh) {
        return pCh != ' ' && pCh != '\"' && pCh != '[' && pCh != ']' && pCh != '.' && pCh != '{' && pCh != '}';
    }

    static Predicate<Tag> createTagPredicate(CompoundTag pTag) {
        return p_99507_ -> NbtUtils.compareNbt(pTag, p_99507_, true);
    }

    static class AllElementsNode
    implements Node {
        public static final AllElementsNode INSTANCE = new AllElementsNode();

        private AllElementsNode() {
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            if (pTag instanceof CollectionTag) {
                pTags.addAll((CollectionTag)pTag);
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            if (pTag instanceof CollectionTag) {
                CollectionTag collectiontag = (CollectionTag)pTag;
                if (collectiontag.isEmpty()) {
                    Tag tag = pSupplier.get();
                    if (collectiontag.addTag(0, tag)) {
                        pTags.add(tag);
                    }
                } else {
                    pTags.addAll(collectiontag);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            if (!(pTag instanceof CollectionTag)) {
                return 0;
            }
            CollectionTag collectiontag = (CollectionTag)pTag;
            int i = collectiontag.size();
            if (i == 0) {
                collectiontag.addTag(0, pSupplier.get());
                return 1;
            }
            Tag tag = pSupplier.get();
            int j = i - (int)collectiontag.stream().filter(tag::equals).count();
            if (j == 0) {
                return 0;
            }
            collectiontag.clear();
            if (!collectiontag.addTag(0, tag)) {
                return 0;
            }
            int k = 1;
            while (k < i) {
                collectiontag.addTag(k, pSupplier.get());
                ++k;
            }
            return j;
        }

        @Override
        public int removeTag(Tag pTag) {
            CollectionTag collectiontag;
            int i;
            if (pTag instanceof CollectionTag && (i = (collectiontag = (CollectionTag)pTag).size()) > 0) {
                collectiontag.clear();
                return i;
            }
            return 0;
        }
    }

    static class CompoundChildNode
    implements Node {
        private final String name;

        public CompoundChildNode(String pName) {
            this.name = pName;
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            Tag tag;
            if (pTag instanceof CompoundTag && (tag = ((CompoundTag)pTag).get(this.name)) != null) {
                pTags.add(tag);
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            if (pTag instanceof CompoundTag) {
                Tag tag;
                CompoundTag compoundtag = (CompoundTag)pTag;
                if (compoundtag.contains(this.name)) {
                    tag = compoundtag.get(this.name);
                } else {
                    tag = pSupplier.get();
                    compoundtag.put(this.name, tag);
                }
                pTags.add(tag);
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            if (pTag instanceof CompoundTag) {
                Tag tag1;
                CompoundTag compoundtag = (CompoundTag)pTag;
                Tag tag = pSupplier.get();
                if (!tag.equals(tag1 = compoundtag.put(this.name, tag))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag pTag) {
            CompoundTag compoundtag;
            if (pTag instanceof CompoundTag && (compoundtag = (CompoundTag)pTag).contains(this.name)) {
                compoundtag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class IndexedElementNode
    implements Node {
        private final int index;

        public IndexedElementNode(int pIndex) {
            this.index = pIndex;
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            if (pTag instanceof CollectionTag) {
                int j;
                CollectionTag collectiontag = (CollectionTag)pTag;
                int i = collectiontag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (j >= 0 && j < i) {
                    pTags.add((Tag)collectiontag.get(j));
                }
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            this.getTag(pTag, pTags);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            if (pTag instanceof CollectionTag) {
                int j;
                CollectionTag collectiontag = (CollectionTag)pTag;
                int i = collectiontag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (j >= 0 && j < i) {
                    Tag tag = (Tag)collectiontag.get(j);
                    Tag tag1 = pSupplier.get();
                    if (!tag1.equals(tag) && collectiontag.setTag(j, tag1)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag pTag) {
            if (pTag instanceof CollectionTag) {
                int j;
                CollectionTag collectiontag = (CollectionTag)pTag;
                int i = collectiontag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (j >= 0 && j < i) {
                    collectiontag.remove(j);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class MatchElementNode
    implements Node {
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchElementNode(CompoundTag pPattern) {
            this.pattern = pPattern;
            this.predicate = NbtPathArgument.createTagPredicate(pPattern);
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            if (pTag instanceof ListTag) {
                ListTag listtag = (ListTag)pTag;
                listtag.stream().filter(this.predicate).forEach(pTags::add);
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            MutableBoolean mutableboolean = new MutableBoolean();
            if (pTag instanceof ListTag) {
                ListTag listtag = (ListTag)pTag;
                listtag.stream().filter(this.predicate).forEach(p_99571_ -> {
                    pTags.add((Tag)p_99571_);
                    mutableboolean.setTrue();
                });
                if (mutableboolean.isFalse()) {
                    CompoundTag compoundtag = this.pattern.copy();
                    listtag.add(compoundtag);
                    pTags.add(compoundtag);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            int i = 0;
            if (pTag instanceof ListTag) {
                ListTag listtag = (ListTag)pTag;
                int j = listtag.size();
                if (j == 0) {
                    listtag.add(pSupplier.get());
                    ++i;
                } else {
                    int k = 0;
                    while (k < j) {
                        Tag tag1;
                        Tag tag = listtag.get(k);
                        if (this.predicate.test(tag) && !(tag1 = pSupplier.get()).equals(tag) && listtag.setTag(k, tag1)) {
                            ++i;
                        }
                        ++k;
                    }
                }
            }
            return i;
        }

        @Override
        public int removeTag(Tag pTag) {
            int i = 0;
            if (pTag instanceof ListTag) {
                ListTag listtag = (ListTag)pTag;
                int j = listtag.size() - 1;
                while (j >= 0) {
                    if (this.predicate.test(listtag.get(j))) {
                        listtag.remove(j);
                        ++i;
                    }
                    --j;
                }
            }
            return i;
        }
    }

    static class MatchObjectNode
    implements Node {
        private final String name;
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchObjectNode(String pName, CompoundTag pPattern) {
            this.name = pName;
            this.pattern = pPattern;
            this.predicate = NbtPathArgument.createTagPredicate(pPattern);
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            Tag tag;
            if (pTag instanceof CompoundTag && this.predicate.test(tag = ((CompoundTag)pTag).get(this.name))) {
                pTags.add(tag);
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            if (pTag instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)pTag;
                Tag tag = compoundtag.get(this.name);
                if (tag == null) {
                    CompoundTag compoundtag1 = this.pattern.copy();
                    compoundtag.put(this.name, compoundtag1);
                    pTags.add(compoundtag1);
                } else if (this.predicate.test(tag)) {
                    pTags.add(tag);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            Tag tag1;
            CompoundTag compoundtag;
            Tag tag;
            if (pTag instanceof CompoundTag && this.predicate.test(tag = (compoundtag = (CompoundTag)pTag).get(this.name)) && !(tag1 = pSupplier.get()).equals(tag)) {
                compoundtag.put(this.name, tag1);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeTag(Tag pTag) {
            CompoundTag compoundtag;
            Tag tag;
            if (pTag instanceof CompoundTag && this.predicate.test(tag = (compoundtag = (CompoundTag)pTag).get(this.name))) {
                compoundtag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class MatchRootObjectNode
    implements Node {
        private final Predicate<Tag> predicate;

        public MatchRootObjectNode(CompoundTag pTag) {
            this.predicate = NbtPathArgument.createTagPredicate(pTag);
        }

        @Override
        public void getTag(Tag pTag, List<Tag> pTags) {
            if (pTag instanceof CompoundTag && this.predicate.test(pTag)) {
                pTags.add(pTag);
            }
        }

        @Override
        public void getOrCreateTag(Tag pTag, Supplier<Tag> pSupplier, List<Tag> pTags) {
            this.getTag(pTag, pTags);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag pTag, Supplier<Tag> pSupplier) {
            return 0;
        }

        @Override
        public int removeTag(Tag pTag) {
            return 0;
        }
    }

    public static class NbtPath {
        private final String original;
        private final Object2IntMap<Node> nodeToOriginalPosition;
        private final Node[] nodes;

        public NbtPath(String pOriginal, Node[] pNodes, Object2IntMap<Node> pNodeToOriginPosition) {
            this.original = pOriginal;
            this.nodes = pNodes;
            this.nodeToOriginalPosition = pNodeToOriginPosition;
        }

        public List<Tag> get(Tag pTag) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(pTag);
            Node[] nodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node nbtpathargument$node = nodeArray[n2];
                if ((list = nbtpathargument$node.get(list)).isEmpty()) {
                    throw this.createNotFoundException(nbtpathargument$node);
                }
                ++n2;
            }
            return list;
        }

        public int countMatching(Tag pTag) {
            List<Tag> list = Collections.singletonList(pTag);
            Node[] nodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node nbtpathargument$node = nodeArray[n2];
                if ((list = nbtpathargument$node.get(list)).isEmpty()) {
                    return 0;
                }
                ++n2;
            }
            return list.size();
        }

        private List<Tag> getOrCreateParents(Tag pTag) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(pTag);
            int i = 0;
            while (i < this.nodes.length - 1) {
                Node nbtpathargument$node = this.nodes[i];
                int j = i + 1;
                if ((list = nbtpathargument$node.getOrCreate(list, this.nodes[j]::createPreferredParentTag)).isEmpty()) {
                    throw this.createNotFoundException(nbtpathargument$node);
                }
                ++i;
            }
            return list;
        }

        public List<Tag> getOrCreate(Tag pTag, Supplier<Tag> pSupplier) throws CommandSyntaxException {
            List<Tag> list = this.getOrCreateParents(pTag);
            Node nbtpathargument$node = this.nodes[this.nodes.length - 1];
            return nbtpathargument$node.getOrCreate(list, pSupplier);
        }

        private static int apply(List<Tag> pTags, Function<Tag, Integer> pFunction) {
            return pTags.stream().map(pFunction).reduce(0, (p_99633_, p_99634_) -> p_99633_ + p_99634_);
        }

        public int set(Tag pTag, Tag pSupplier) throws CommandSyntaxException {
            return this.set(pTag, pSupplier::copy);
        }

        public int set(Tag pTag, Supplier<Tag> pSupplier) throws CommandSyntaxException {
            List<Tag> list = this.getOrCreateParents(pTag);
            Node nbtpathargument$node = this.nodes[this.nodes.length - 1];
            return NbtPath.apply(list, p_99631_ -> nbtpathargument$node.setTag((Tag)p_99631_, pSupplier));
        }

        public int remove(Tag pTag) {
            List<Tag> list = Collections.singletonList(pTag);
            int i = 0;
            while (i < this.nodes.length - 1) {
                list = this.nodes[i].get(list);
                ++i;
            }
            Node nbtpathargument$node = this.nodes[this.nodes.length - 1];
            return NbtPath.apply(list, nbtpathargument$node::removeTag);
        }

        private CommandSyntaxException createNotFoundException(Node pNode) {
            int i = this.nodeToOriginalPosition.getInt((Object)pNode);
            return ERROR_NOTHING_FOUND.create((Object)this.original.substring(0, i));
        }

        public String toString() {
            return this.original;
        }
    }

    static interface Node {
        public void getTag(Tag var1, List<Tag> var2);

        public void getOrCreateTag(Tag var1, Supplier<Tag> var2, List<Tag> var3);

        public Tag createPreferredParentTag();

        public int setTag(Tag var1, Supplier<Tag> var2);

        public int removeTag(Tag var1);

        default public List<Tag> get(List<Tag> pTags) {
            return this.collect(pTags, this::getTag);
        }

        default public List<Tag> getOrCreate(List<Tag> pTags, Supplier<Tag> pSupplier) {
            return this.collect(pTags, (p_99663_, p_99664_) -> this.getOrCreateTag((Tag)p_99663_, pSupplier, (List<Tag>)p_99664_));
        }

        default public List<Tag> collect(List<Tag> pTags, BiConsumer<Tag, List<Tag>> pConsumer) {
            ArrayList list = Lists.newArrayList();
            for (Tag tag : pTags) {
                pConsumer.accept(tag, list);
            }
            return list;
        }
    }
}

