/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;

public class ObjectiveArgument
implements ArgumentType<String> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "*", "012");
    private static final DynamicCommandExceptionType ERROR_OBJECTIVE_NOT_FOUND = new DynamicCommandExceptionType(p_101971_ -> new TranslatableComponent("arguments.objective.notFound", p_101971_));
    private static final DynamicCommandExceptionType ERROR_OBJECTIVE_READ_ONLY = new DynamicCommandExceptionType(p_101969_ -> new TranslatableComponent("arguments.objective.readonly", p_101969_));

    public static ObjectiveArgument objective() {
        return new ObjectiveArgument();
    }

    public static Objective getObjective(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        String s = (String)pContext.getArgument(pName, String.class);
        ServerScoreboard scoreboard = ((CommandSourceStack)pContext.getSource()).getServer().getScoreboard();
        Objective objective = scoreboard.getObjective(s);
        if (objective == null) {
            throw ERROR_OBJECTIVE_NOT_FOUND.create((Object)s);
        }
        return objective;
    }

    public static Objective getWritableObjective(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        Objective objective = ObjectiveArgument.getObjective(pContext, pName);
        if (objective.getCriteria().isReadOnly()) {
            throw ERROR_OBJECTIVE_READ_ONLY.create((Object)objective.getName());
        }
        return objective;
    }

    public String parse(StringReader pReader) throws CommandSyntaxException {
        return pReader.readUnquotedString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        Object s = pContext.getSource();
        if (s instanceof CommandSourceStack) {
            CommandSourceStack commandsourcestack = (CommandSourceStack)s;
            return SharedSuggestionProvider.suggest(commandsourcestack.getServer().getScoreboard().getObjectiveNames(), pBuilder);
        }
        if (s instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)s;
            return sharedsuggestionprovider.customSuggestion(pContext);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

