/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.scores.Score;

public class OperationArgument
implements ArgumentType<Operation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType ERROR_INVALID_OPERATION = new SimpleCommandExceptionType((Message)new TranslatableComponent("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType ERROR_DIVIDE_BY_ZERO = new SimpleCommandExceptionType((Message)new TranslatableComponent("arguments.operation.div0"));

    public static OperationArgument operation() {
        return new OperationArgument();
    }

    public static Operation getOperation(CommandContext<CommandSourceStack> pContext, String pName) {
        return (Operation)pContext.getArgument(pName, Operation.class);
    }

    public Operation parse(StringReader pReader) throws CommandSyntaxException {
        if (!pReader.canRead()) {
            throw ERROR_INVALID_OPERATION.create();
        }
        int i = pReader.getCursor();
        while (pReader.canRead() && pReader.peek() != ' ') {
            pReader.skip();
        }
        return OperationArgument.getOperation(pReader.getString().substring(i, pReader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.a(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, pBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperation(String pName) throws CommandSyntaxException {
        return pName.equals("><") ? (p_103279_, p_103280_) -> {
            int i = p_103279_.getScore();
            p_103279_.setScore(p_103280_.getScore());
            p_103280_.setScore(i);
        } : OperationArgument.getSimpleOperation(pName);
    }

    private static SimpleOperation getSimpleOperation(String pName) throws CommandSyntaxException {
        switch (pName) {
            case "=": {
                return (p_103298_, p_103299_) -> p_103299_;
            }
            case "+=": {
                return (p_103295_, p_103296_) -> p_103295_ + p_103296_;
            }
            case "-=": {
                return (p_103292_, p_103293_) -> p_103292_ - p_103293_;
            }
            case "*=": {
                return (p_103289_, p_103290_) -> p_103289_ * p_103290_;
            }
            case "/=": {
                return (p_103284_, p_103285_) -> {
                    if (p_103285_ == 0) {
                        throw ERROR_DIVIDE_BY_ZERO.create();
                    }
                    return Mth.intFloorDiv(p_103284_, p_103285_);
                };
            }
            case "%=": {
                return (p_103271_, p_103272_) -> {
                    if (p_103272_ == 0) {
                        throw ERROR_DIVIDE_BY_ZERO.create();
                    }
                    return Mth.positiveModulo(p_103271_, p_103272_);
                };
            }
            case "<": {
                return Math::min;
            }
            case ">": {
                return Math::max;
            }
        }
        throw ERROR_INVALID_OPERATION.create();
    }

    @FunctionalInterface
    public static interface Operation {
        public void apply(Score var1, Score var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface SimpleOperation
    extends Operation {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(Score pTargetScore, Score pSourceScore) throws CommandSyntaxException {
            pTargetScore.setScore(this.apply(pTargetScore.getScore(), pSourceScore.getScore()));
        }
    }
}

