/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ParticleArgument
implements ArgumentType<ParticleOptions> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle with options");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType(p_103941_ -> new TranslatableComponent("particle.notFound", p_103941_));

    public static ParticleArgument particle() {
        return new ParticleArgument();
    }

    public static ParticleOptions getParticle(CommandContext<CommandSourceStack> pContext, String pName) {
        return (ParticleOptions)pContext.getArgument(pName, ParticleOptions.class);
    }

    public ParticleOptions parse(StringReader pReader) throws CommandSyntaxException {
        return ParticleArgument.readParticle(pReader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleOptions readParticle(StringReader pReader) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.read(pReader);
        ParticleType<?> particletype = Registry.PARTICLE_TYPE.getOptional(resourcelocation).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.create((Object)resourcelocation));
        return ParticleArgument.readParticle(pReader, particletype);
    }

    private static <T extends ParticleOptions> T readParticle(StringReader pReader, ParticleType<T> pType) throws CommandSyntaxException {
        return pType.getDeserializer().fromCommand(pType, pReader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.suggestResource(Registry.PARTICLE_TYPE.keySet(), pBuilder);
    }
}

