/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceLocationArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ADVANCEMENT = new DynamicCommandExceptionType(p_107010_ -> new TranslatableComponent("advancement.advancementNotFound", p_107010_));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_RECIPE = new DynamicCommandExceptionType(p_107005_ -> new TranslatableComponent("recipe.notFound", p_107005_));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PREDICATE = new DynamicCommandExceptionType(p_106998_ -> new TranslatableComponent("predicate.unknown", p_106998_));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM_MODIFIER = new DynamicCommandExceptionType(p_106991_ -> new TranslatableComponent("item_modifier.unknown", p_106991_));

    public static ResourceLocationArgument id() {
        return new ResourceLocationArgument();
    }

    public static Advancement getAdvancement(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pContext, pName);
        Advancement advancement = ((CommandSourceStack)pContext.getSource()).getServer().getAdvancements().getAdvancement(resourcelocation);
        if (advancement == null) {
            throw ERROR_UNKNOWN_ADVANCEMENT.create((Object)resourcelocation);
        }
        return advancement;
    }

    public static Recipe<?> getRecipe(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        RecipeManager recipemanager = ((CommandSourceStack)pContext.getSource()).getServer().getRecipeManager();
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pContext, pName);
        return recipemanager.byKey(resourcelocation).orElseThrow(() -> ERROR_UNKNOWN_RECIPE.create((Object)resourcelocation));
    }

    public static LootItemCondition getPredicate(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pContext, pName);
        PredicateManager predicatemanager = ((CommandSourceStack)pContext.getSource()).getServer().getPredicateManager();
        LootItemCondition lootitemcondition = predicatemanager.get(resourcelocation);
        if (lootitemcondition == null) {
            throw ERROR_UNKNOWN_PREDICATE.create((Object)resourcelocation);
        }
        return lootitemcondition;
    }

    public static LootItemFunction getItemModifier(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pContext, pName);
        ItemModifierManager itemmodifiermanager = ((CommandSourceStack)pContext.getSource()).getServer().getItemModifierManager();
        LootItemFunction lootitemfunction = itemmodifiermanager.get(resourcelocation);
        if (lootitemfunction == null) {
            throw ERROR_UNKNOWN_ITEM_MODIFIER.create((Object)resourcelocation);
        }
        return lootitemfunction;
    }

    public static ResourceLocation getId(CommandContext<CommandSourceStack> pContext, String pName) {
        return (ResourceLocation)pContext.getArgument(pName, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader pReader) throws CommandSyntaxException {
        return ResourceLocation.read(pReader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

