/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(p_115580_ -> new TranslatableComponent("arguments.block.tag.unknown", p_115580_));

    public static BlockPredicateArgument blockPredicate() {
        return new BlockPredicateArgument();
    }

    public Result parse(StringReader pReader) throws CommandSyntaxException {
        BlockStateParser blockstateparser = new BlockStateParser(pReader, true).parse(true);
        if (blockstateparser.getState() != null) {
            BlockPredicate blockpredicateargument$blockpredicate = new BlockPredicate(blockstateparser.getState(), blockstateparser.getProperties().keySet(), blockstateparser.getNbt());
            return new Result(){

                @Override
                public Predicate<BlockInWorld> create(Registry<Block> p_205581_) {
                    return blockpredicateargument$blockpredicate;
                }

                @Override
                public boolean requiresNbt() {
                    return blockpredicateargument$blockpredicate.requiresNbt();
                }
            };
        }
        TagKey<Block> tagkey = blockstateparser.getTag();
        return new Result(){

            @Override
            public Predicate<BlockInWorld> create(Registry<Block> p_205588_) throws CommandSyntaxException {
                if (!p_205588_.isKnownTagName(tagkey)) {
                    throw ERROR_UNKNOWN_TAG.create((Object)tagkey);
                }
                return new TagPredicate(tagkey, blockstateparser.getVagueProperties(), blockstateparser.getNbt());
            }

            @Override
            public boolean requiresNbt() {
                return blockstateparser.getNbt() != null;
            }
        };
    }

    public static Predicate<BlockInWorld> getBlockPredicate(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return ((Result)pContext.getArgument(pName, Result.class)).create(((CommandSourceStack)pContext.getSource()).getServer().registryAccess().registryOrThrow(Registry.BLOCK_REGISTRY));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        StringReader stringreader = new StringReader(pBuilder.getInput());
        stringreader.setCursor(pBuilder.getStart());
        BlockStateParser blockstateparser = new BlockStateParser(stringreader, true);
        try {
            blockstateparser.parse(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return blockstateparser.fillSuggestions(pBuilder, Registry.BLOCK);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static class BlockPredicate
    implements Predicate<BlockInWorld> {
        private final BlockState state;
        private final Set<Property<?>> properties;
        @Nullable
        private final CompoundTag nbt;

        public BlockPredicate(BlockState pState, Set<Property<?>> pProperties, @Nullable CompoundTag pNbt) {
            this.state = pState;
            this.properties = pProperties;
            this.nbt = pNbt;
        }

        @Override
        public boolean test(BlockInWorld pBlock) {
            BlockState blockstate = pBlock.getState();
            if (!blockstate.is(this.state.getBlock())) {
                return false;
            }
            for (Property<?> property : this.properties) {
                if (blockstate.getValue(property) == this.state.getValue(property)) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            BlockEntity blockentity = pBlock.getEntity();
            return blockentity != null && NbtUtils.compareNbt(this.nbt, blockentity.saveWithFullMetadata(), true);
        }

        public boolean requiresNbt() {
            return this.nbt != null;
        }
    }

    public static interface Result {
        public Predicate<BlockInWorld> create(Registry<Block> var1) throws CommandSyntaxException;

        public boolean requiresNbt();
    }

    static class TagPredicate
    implements Predicate<BlockInWorld> {
        private final TagKey<Block> tag;
        @Nullable
        private final CompoundTag nbt;
        private final Map<String, String> vagueProperties;

        TagPredicate(TagKey<Block> pTag, Map<String, String> pVagueProperties, @Nullable CompoundTag pNbt) {
            this.tag = pTag;
            this.vagueProperties = pVagueProperties;
            this.nbt = pNbt;
        }

        @Override
        public boolean test(BlockInWorld pBlock) {
            BlockState blockstate = pBlock.getState();
            if (!blockstate.is(this.tag)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.vagueProperties.entrySet()) {
                Property<?> property = blockstate.getBlock().getStateDefinition().getProperty(entry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable comparable = property.getValue(entry.getValue()).orElse(null);
                if (comparable == null) {
                    return false;
                }
                if (blockstate.getValue(property) == comparable) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            BlockEntity blockentity = pBlock.getEntity();
            return blockentity != null && NbtUtils.compareNbt(this.nbt, blockentity.saveWithFullMetadata(), true);
        }
    }
}

