/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;

public class FunctionArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "#foo");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(p_120927_ -> new TranslatableComponent("arguments.function.tag.unknown", p_120927_));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_FUNCTION = new DynamicCommandExceptionType(p_120917_ -> new TranslatableComponent("arguments.function.unknown", p_120917_));

    public static FunctionArgument functions() {
        return new FunctionArgument();
    }

    public Result parse(StringReader pReader) throws CommandSyntaxException {
        if (pReader.canRead() && pReader.peek() == '#') {
            pReader.skip();
            ResourceLocation resourcelocation1 = ResourceLocation.read(pReader);
            return new Result(){

                @Override
                public Collection<CommandFunction> create(CommandContext<CommandSourceStack> p_120943_) throws CommandSyntaxException {
                    Tag<CommandFunction> tag = FunctionArgument.getFunctionTag(p_120943_, resourcelocation1);
                    return tag.getValues();
                }

                @Override
                public Pair<ResourceLocation, Either<CommandFunction, Tag<CommandFunction>>> unwrap(CommandContext<CommandSourceStack> p_120945_) throws CommandSyntaxException {
                    return Pair.of((Object)resourcelocation1, (Object)Either.right(FunctionArgument.getFunctionTag(p_120945_, resourcelocation1)));
                }
            };
        }
        ResourceLocation resourcelocation = ResourceLocation.read(pReader);
        return new Result(){

            @Override
            public Collection<CommandFunction> create(CommandContext<CommandSourceStack> p_120952_) throws CommandSyntaxException {
                return Collections.singleton(FunctionArgument.getFunction(p_120952_, resourcelocation));
            }

            @Override
            public Pair<ResourceLocation, Either<CommandFunction, Tag<CommandFunction>>> unwrap(CommandContext<CommandSourceStack> p_120954_) throws CommandSyntaxException {
                return Pair.of((Object)resourcelocation, (Object)Either.left((Object)FunctionArgument.getFunction(p_120954_, resourcelocation)));
            }
        };
    }

    static CommandFunction getFunction(CommandContext<CommandSourceStack> pContext, ResourceLocation pId) throws CommandSyntaxException {
        return ((CommandSourceStack)pContext.getSource()).getServer().getFunctions().get(pId).orElseThrow(() -> ERROR_UNKNOWN_FUNCTION.create((Object)pId.toString()));
    }

    static Tag<CommandFunction> getFunctionTag(CommandContext<CommandSourceStack> pContext, ResourceLocation pId) throws CommandSyntaxException {
        Tag<CommandFunction> tag = ((CommandSourceStack)pContext.getSource()).getServer().getFunctions().getTag(pId);
        if (tag == null) {
            throw ERROR_UNKNOWN_TAG.create((Object)pId.toString());
        }
        return tag;
    }

    public static Collection<CommandFunction> getFunctions(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return ((Result)pContext.getArgument(pName, Result.class)).create(pContext);
    }

    public static Pair<ResourceLocation, Either<CommandFunction, Tag<CommandFunction>>> getFunctionOrTag(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return ((Result)pContext.getArgument(pName, Result.class)).unwrap(pContext);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface Result {
        public Collection<CommandFunction> create(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public Pair<ResourceLocation, Either<CommandFunction, Tag<CommandFunction>>> unwrap(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

