/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.MobEffectArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.BrigadierArgumentSerializers;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ArgumentTypes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Class<?>, Entry<?>> BY_CLASS = Maps.newHashMap();
    private static final Map<ResourceLocation, Entry<?>> BY_NAME = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void register(String pName, Class<T> pClazz, ArgumentSerializer<T> pSerializer) {
        ResourceLocation resourcelocation = new ResourceLocation(pName);
        if (BY_CLASS.containsKey(pClazz)) {
            throw new IllegalArgumentException("Class " + pClazz.getName() + " already has a serializer!");
        }
        if (BY_NAME.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("'" + resourcelocation + "' is already a registered serializer!");
        }
        Entry<T> entry = new Entry<T>(pSerializer, resourcelocation);
        BY_CLASS.put(pClazz, entry);
        BY_NAME.put(resourcelocation, entry);
    }

    public static void bootStrap() {
        BrigadierArgumentSerializers.bootstrap();
        ArgumentTypes.register("entity", EntityArgument.class, new EntityArgument.Serializer());
        ArgumentTypes.register("game_profile", GameProfileArgument.class, new EmptyArgumentSerializer<GameProfileArgument>(GameProfileArgument::gameProfile));
        ArgumentTypes.register("block_pos", BlockPosArgument.class, new EmptyArgumentSerializer<BlockPosArgument>(BlockPosArgument::blockPos));
        ArgumentTypes.register("column_pos", ColumnPosArgument.class, new EmptyArgumentSerializer<ColumnPosArgument>(ColumnPosArgument::columnPos));
        ArgumentTypes.register("vec3", Vec3Argument.class, new EmptyArgumentSerializer<Vec3Argument>(Vec3Argument::vec3));
        ArgumentTypes.register("vec2", Vec2Argument.class, new EmptyArgumentSerializer<Vec2Argument>(Vec2Argument::vec2));
        ArgumentTypes.register("block_state", BlockStateArgument.class, new EmptyArgumentSerializer<BlockStateArgument>(BlockStateArgument::block));
        ArgumentTypes.register("block_predicate", BlockPredicateArgument.class, new EmptyArgumentSerializer<BlockPredicateArgument>(BlockPredicateArgument::blockPredicate));
        ArgumentTypes.register("item_stack", ItemArgument.class, new EmptyArgumentSerializer<ItemArgument>(ItemArgument::item));
        ArgumentTypes.register("item_predicate", ItemPredicateArgument.class, new EmptyArgumentSerializer<ItemPredicateArgument>(ItemPredicateArgument::itemPredicate));
        ArgumentTypes.register("color", ColorArgument.class, new EmptyArgumentSerializer<ColorArgument>(ColorArgument::color));
        ArgumentTypes.register("component", ComponentArgument.class, new EmptyArgumentSerializer<ComponentArgument>(ComponentArgument::textComponent));
        ArgumentTypes.register("message", MessageArgument.class, new EmptyArgumentSerializer<MessageArgument>(MessageArgument::message));
        ArgumentTypes.register("nbt_compound_tag", CompoundTagArgument.class, new EmptyArgumentSerializer<CompoundTagArgument>(CompoundTagArgument::compoundTag));
        ArgumentTypes.register("nbt_tag", NbtTagArgument.class, new EmptyArgumentSerializer<NbtTagArgument>(NbtTagArgument::nbtTag));
        ArgumentTypes.register("nbt_path", NbtPathArgument.class, new EmptyArgumentSerializer<NbtPathArgument>(NbtPathArgument::nbtPath));
        ArgumentTypes.register("objective", ObjectiveArgument.class, new EmptyArgumentSerializer<ObjectiveArgument>(ObjectiveArgument::objective));
        ArgumentTypes.register("objective_criteria", ObjectiveCriteriaArgument.class, new EmptyArgumentSerializer<ObjectiveCriteriaArgument>(ObjectiveCriteriaArgument::criteria));
        ArgumentTypes.register("operation", OperationArgument.class, new EmptyArgumentSerializer<OperationArgument>(OperationArgument::operation));
        ArgumentTypes.register("particle", ParticleArgument.class, new EmptyArgumentSerializer<ParticleArgument>(ParticleArgument::particle));
        ArgumentTypes.register("angle", AngleArgument.class, new EmptyArgumentSerializer<AngleArgument>(AngleArgument::angle));
        ArgumentTypes.register("rotation", RotationArgument.class, new EmptyArgumentSerializer<RotationArgument>(RotationArgument::rotation));
        ArgumentTypes.register("scoreboard_slot", ScoreboardSlotArgument.class, new EmptyArgumentSerializer<ScoreboardSlotArgument>(ScoreboardSlotArgument::displaySlot));
        ArgumentTypes.register("score_holder", ScoreHolderArgument.class, new ScoreHolderArgument.Serializer());
        ArgumentTypes.register("swizzle", SwizzleArgument.class, new EmptyArgumentSerializer<SwizzleArgument>(SwizzleArgument::swizzle));
        ArgumentTypes.register("team", TeamArgument.class, new EmptyArgumentSerializer<TeamArgument>(TeamArgument::team));
        ArgumentTypes.register("item_slot", SlotArgument.class, new EmptyArgumentSerializer<SlotArgument>(SlotArgument::slot));
        ArgumentTypes.register("resource_location", ResourceLocationArgument.class, new EmptyArgumentSerializer<ResourceLocationArgument>(ResourceLocationArgument::id));
        ArgumentTypes.register("mob_effect", MobEffectArgument.class, new EmptyArgumentSerializer<MobEffectArgument>(MobEffectArgument::effect));
        ArgumentTypes.register("function", FunctionArgument.class, new EmptyArgumentSerializer<FunctionArgument>(FunctionArgument::functions));
        ArgumentTypes.register("entity_anchor", EntityAnchorArgument.class, new EmptyArgumentSerializer<EntityAnchorArgument>(EntityAnchorArgument::anchor));
        ArgumentTypes.register("int_range", RangeArgument.Ints.class, new EmptyArgumentSerializer<RangeArgument.Ints>(RangeArgument::intRange));
        ArgumentTypes.register("float_range", RangeArgument.Floats.class, new EmptyArgumentSerializer<RangeArgument.Floats>(RangeArgument::floatRange));
        ArgumentTypes.register("item_enchantment", ItemEnchantmentArgument.class, new EmptyArgumentSerializer<ItemEnchantmentArgument>(ItemEnchantmentArgument::enchantment));
        ArgumentTypes.register("entity_summon", EntitySummonArgument.class, new EmptyArgumentSerializer<EntitySummonArgument>(EntitySummonArgument::id));
        ArgumentTypes.register("dimension", DimensionArgument.class, new EmptyArgumentSerializer<DimensionArgument>(DimensionArgument::dimension));
        ArgumentTypes.register("time", TimeArgument.class, new EmptyArgumentSerializer<TimeArgument>(TimeArgument::time));
        ArgumentTypes.register("uuid", UuidArgument.class, new EmptyArgumentSerializer<UuidArgument>(UuidArgument::uuid));
        ArgumentTypes.register("resource", ArgumentTypes.fixClassType(ResourceKeyArgument.class), new ResourceKeyArgument.Serializer());
        ArgumentTypes.register("resource_or_tag", ArgumentTypes.fixClassType(ResourceOrTagLocationArgument.class), new ResourceOrTagLocationArgument.Serializer());
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ArgumentTypes.register("test_argument", TestFunctionArgument.class, new EmptyArgumentSerializer<TestFunctionArgument>(TestFunctionArgument::testFunctionArgument));
            ArgumentTypes.register("test_class", TestClassNameArgument.class, new EmptyArgumentSerializer<TestClassNameArgument>(TestClassNameArgument::testClassName));
        }
    }

    private static <T extends ArgumentType<?>> Class<T> fixClassType(Class<? super T> p_211032_) {
        return p_211032_;
    }

    @Nullable
    private static Entry<?> get(ResourceLocation pType) {
        return BY_NAME.get(pType);
    }

    @Nullable
    private static Entry<?> get(ArgumentType<?> pType) {
        return BY_CLASS.get(pType.getClass());
    }

    public static <T extends ArgumentType<?>> void serialize(FriendlyByteBuf pBuffer, T pType) {
        Entry<?> entry = ArgumentTypes.get(pType);
        if (entry == null) {
            LOGGER.error("Could not serialize {} ({}) - will not be sent to client!", pType, pType.getClass());
            pBuffer.writeResourceLocation(new ResourceLocation(""));
        } else {
            pBuffer.writeResourceLocation(entry.name);
            entry.serializer.serializeToNetwork(pType, pBuffer);
        }
    }

    @Nullable
    public static ArgumentType<?> deserialize(FriendlyByteBuf pBuffer) {
        ResourceLocation resourcelocation = pBuffer.readResourceLocation();
        Entry<?> entry = ArgumentTypes.get(resourcelocation);
        if (entry == null) {
            LOGGER.error("Could not deserialize {}", (Object)resourcelocation);
            return null;
        }
        return entry.serializer.deserializeFromNetwork(pBuffer);
    }

    private static <T extends ArgumentType<?>> void serializeToJson(JsonObject pJson, T pType) {
        Entry<?> entry = ArgumentTypes.get(pType);
        if (entry == null) {
            LOGGER.error("Could not serialize argument {} ({})!", pType, pType.getClass());
            pJson.addProperty("type", "unknown");
        } else {
            pJson.addProperty("type", "argument");
            pJson.addProperty("parser", entry.name.toString());
            JsonObject jsonobject = new JsonObject();
            entry.serializer.serializeToJson(pType, jsonobject);
            if (jsonobject.size() > 0) {
                pJson.add("properties", (JsonElement)jsonobject);
            }
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> pDispatcher, CommandNode<S> pNode) {
        Collection collection;
        JsonObject jsonobject = new JsonObject();
        if (pNode instanceof RootCommandNode) {
            jsonobject.addProperty("type", "root");
        } else if (pNode instanceof LiteralCommandNode) {
            jsonobject.addProperty("type", "literal");
        } else if (pNode instanceof ArgumentCommandNode) {
            ArgumentTypes.serializeToJson(jsonobject, ((ArgumentCommandNode)pNode).getType());
        } else {
            LOGGER.error("Could not serialize node {} ({})!", pNode, pNode.getClass());
            jsonobject.addProperty("type", "unknown");
        }
        JsonObject jsonobject1 = new JsonObject();
        for (CommandNode commandnode : pNode.getChildren()) {
            jsonobject1.add(commandnode.getName(), (JsonElement)ArgumentTypes.serializeNodeToJson(pDispatcher, commandnode));
        }
        if (jsonobject1.size() > 0) {
            jsonobject.add("children", (JsonElement)jsonobject1);
        }
        if (pNode.getCommand() != null) {
            jsonobject.addProperty("executable", Boolean.valueOf(true));
        }
        if (pNode.getRedirect() != null && !(collection = pDispatcher.getPath(pNode.getRedirect())).isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (String s : collection) {
                jsonarray.add(s);
            }
            jsonobject.add("redirect", (JsonElement)jsonarray);
        }
        return jsonobject;
    }

    public static boolean isTypeRegistered(ArgumentType<?> pType) {
        return ArgumentTypes.get(pType) != null;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> pNode) {
        Set set = Sets.newIdentityHashSet();
        HashSet set1 = Sets.newHashSet();
        ArgumentTypes.findUsedArgumentTypes(pNode, set1, set);
        return set1;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> pNode, Set<ArgumentType<?>> pTypes, Set<CommandNode<T>> pNodes) {
        if (pNodes.add(pNode)) {
            if (pNode instanceof ArgumentCommandNode) {
                pTypes.add(((ArgumentCommandNode)pNode).getType());
            }
            pNode.getChildren().forEach(p_121608_ -> ArgumentTypes.findUsedArgumentTypes(p_121608_, pTypes, pNodes));
            CommandNode commandnode = pNode.getRedirect();
            if (commandnode != null) {
                ArgumentTypes.findUsedArgumentTypes(commandnode, pTypes, pNodes);
            }
        }
    }

    static class Entry<T extends ArgumentType<?>> {
        public final ArgumentSerializer<T> serializer;
        public final ResourceLocation name;

        Entry(ArgumentSerializer<T> p_211034_, ResourceLocation p_211035_) {
            this.serializer = p_211034_;
            this.name = p_211035_;
        }
    }
}

