/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class SuggestionProviders {
    private static final Map<ResourceLocation, SuggestionProvider<SharedSuggestionProvider>> PROVIDERS_BY_NAME = Maps.newHashMap();
    private static final ResourceLocation DEFAULT_NAME = new ResourceLocation("ask_server");
    public static final SuggestionProvider<SharedSuggestionProvider> ASK_SERVER = SuggestionProviders.register(DEFAULT_NAME, (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_121673_, p_121674_) -> ((SharedSuggestionProvider)p_121673_.getSource()).customSuggestion(p_121673_)));
    public static final SuggestionProvider<CommandSourceStack> ALL_RECIPES = SuggestionProviders.register(new ResourceLocation("all_recipes"), (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_121670_, p_121671_) -> SharedSuggestionProvider.suggestResource(((SharedSuggestionProvider)p_121670_.getSource()).getRecipeNames(), p_121671_)));
    public static final SuggestionProvider<CommandSourceStack> AVAILABLE_SOUNDS = SuggestionProviders.register(new ResourceLocation("available_sounds"), (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_121667_, p_121668_) -> SharedSuggestionProvider.suggestResource(((SharedSuggestionProvider)p_121667_.getSource()).getAvailableSoundEvents(), p_121668_)));
    public static final SuggestionProvider<CommandSourceStack> SUMMONABLE_ENTITIES = SuggestionProviders.register(new ResourceLocation("summonable_entities"), (SuggestionProvider<SharedSuggestionProvider>)((SuggestionProvider)(p_212438_, p_212439_) -> SharedSuggestionProvider.suggestResource(Registry.ENTITY_TYPE.stream().filter(EntityType::canSummon), p_212439_, EntityType::getKey, p_212436_ -> new TranslatableComponent(Util.makeDescriptionId("entity", EntityType.getKey(p_212436_))))));

    public static <S extends SharedSuggestionProvider> SuggestionProvider<S> register(ResourceLocation pName, SuggestionProvider<SharedSuggestionProvider> pProvider) {
        if (PROVIDERS_BY_NAME.containsKey(pName)) {
            throw new IllegalArgumentException("A command suggestion provider is already registered with the name " + pName);
        }
        PROVIDERS_BY_NAME.put(pName, pProvider);
        return new Wrapper(pName, pProvider);
    }

    public static SuggestionProvider<SharedSuggestionProvider> getProvider(ResourceLocation pName) {
        return PROVIDERS_BY_NAME.getOrDefault(pName, ASK_SERVER);
    }

    public static ResourceLocation getName(SuggestionProvider<SharedSuggestionProvider> pProvider) {
        return pProvider instanceof Wrapper ? ((Wrapper)pProvider).name : DEFAULT_NAME;
    }

    public static SuggestionProvider<SharedSuggestionProvider> safelySwap(SuggestionProvider<SharedSuggestionProvider> pProvider) {
        return pProvider instanceof Wrapper ? pProvider : ASK_SERVER;
    }

    protected static class Wrapper
    implements SuggestionProvider<SharedSuggestionProvider> {
        private final SuggestionProvider<SharedSuggestionProvider> delegate;
        final ResourceLocation name;

        public Wrapper(ResourceLocation pName, SuggestionProvider<SharedSuggestionProvider> pDelegate) {
            this.delegate = pDelegate;
            this.name = pName;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<SharedSuggestionProvider> pContext, SuggestionsBuilder pBuilder) throws CommandSyntaxException {
            return this.delegate.getSuggestions(pContext, pBuilder);
        }
    }
}

