/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.BrigadierArgumentSerializers;
import net.minecraft.network.FriendlyByteBuf;

public class DoubleArgumentSerializer
implements ArgumentSerializer<DoubleArgumentType> {
    @Override
    public void serializeToNetwork(DoubleArgumentType pArgument, FriendlyByteBuf pBuffer) {
        boolean flag = pArgument.getMinimum() != -1.7976931348623157E308;
        boolean flag1 = pArgument.getMaximum() != Double.MAX_VALUE;
        pBuffer.writeByte(BrigadierArgumentSerializers.createNumberFlags(flag, flag1));
        if (flag) {
            pBuffer.writeDouble(pArgument.getMinimum());
        }
        if (flag1) {
            pBuffer.writeDouble(pArgument.getMaximum());
        }
    }

    @Override
    public DoubleArgumentType deserializeFromNetwork(FriendlyByteBuf pBuffer) {
        byte b0 = pBuffer.readByte();
        double d0 = BrigadierArgumentSerializers.numberHasMin(b0) ? pBuffer.readDouble() : -1.7976931348623157E308;
        double d1 = BrigadierArgumentSerializers.numberHasMax(b0) ? pBuffer.readDouble() : Double.MAX_VALUE;
        return DoubleArgumentType.doubleArg((double)d0, (double)d1);
    }

    @Override
    public void serializeToJson(DoubleArgumentType pArgument, JsonObject pJson) {
        if (pArgument.getMinimum() != -1.7976931348623157E308) {
            pJson.addProperty("min", (Number)pArgument.getMinimum());
        }
        if (pArgument.getMaximum() != Double.MAX_VALUE) {
            pJson.addProperty("max", (Number)pArgument.getMaximum());
        }
    }
}

