/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.BrigadierArgumentSerializers;
import net.minecraft.network.FriendlyByteBuf;

public class FloatArgumentSerializer
implements ArgumentSerializer<FloatArgumentType> {
    @Override
    public void serializeToNetwork(FloatArgumentType pArgument, FriendlyByteBuf pBuffer) {
        boolean flag = pArgument.getMinimum() != -3.4028235E38f;
        boolean flag1 = pArgument.getMaximum() != Float.MAX_VALUE;
        pBuffer.writeByte(BrigadierArgumentSerializers.createNumberFlags(flag, flag1));
        if (flag) {
            pBuffer.writeFloat(pArgument.getMinimum());
        }
        if (flag1) {
            pBuffer.writeFloat(pArgument.getMaximum());
        }
    }

    @Override
    public FloatArgumentType deserializeFromNetwork(FriendlyByteBuf pBuffer) {
        byte b0 = pBuffer.readByte();
        float f = BrigadierArgumentSerializers.numberHasMin(b0) ? pBuffer.readFloat() : -3.4028235E38f;
        float f1 = BrigadierArgumentSerializers.numberHasMax(b0) ? pBuffer.readFloat() : Float.MAX_VALUE;
        return FloatArgumentType.floatArg((float)f, (float)f1);
    }

    @Override
    public void serializeToJson(FloatArgumentType pArgument, JsonObject pJson) {
        if (pArgument.getMinimum() != -3.4028235E38f) {
            pJson.addProperty("min", (Number)Float.valueOf(pArgument.getMinimum()));
        }
        if (pArgument.getMaximum() != Float.MAX_VALUE) {
            pJson.addProperty("max", (Number)Float.valueOf(pArgument.getMaximum()));
        }
    }
}

