/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.BrigadierArgumentSerializers;
import net.minecraft.network.FriendlyByteBuf;

public class IntegerArgumentSerializer
implements ArgumentSerializer<IntegerArgumentType> {
    @Override
    public void serializeToNetwork(IntegerArgumentType pArgument, FriendlyByteBuf pBuffer) {
        boolean flag = pArgument.getMinimum() != Integer.MIN_VALUE;
        boolean flag1 = pArgument.getMaximum() != Integer.MAX_VALUE;
        pBuffer.writeByte(BrigadierArgumentSerializers.createNumberFlags(flag, flag1));
        if (flag) {
            pBuffer.writeInt(pArgument.getMinimum());
        }
        if (flag1) {
            pBuffer.writeInt(pArgument.getMaximum());
        }
    }

    @Override
    public IntegerArgumentType deserializeFromNetwork(FriendlyByteBuf pBuffer) {
        byte b0 = pBuffer.readByte();
        int i = BrigadierArgumentSerializers.numberHasMin(b0) ? pBuffer.readInt() : Integer.MIN_VALUE;
        int j = BrigadierArgumentSerializers.numberHasMax(b0) ? pBuffer.readInt() : Integer.MAX_VALUE;
        return IntegerArgumentType.integer((int)i, (int)j);
    }

    @Override
    public void serializeToJson(IntegerArgumentType pArgument, JsonObject pJson) {
        if (pArgument.getMinimum() != Integer.MIN_VALUE) {
            pJson.addProperty("min", (Number)pArgument.getMinimum());
        }
        if (pArgument.getMaximum() != Integer.MAX_VALUE) {
            pJson.addProperty("max", (Number)pArgument.getMaximum());
        }
    }
}

