/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;

public class StringArgumentSerializer
implements ArgumentSerializer<StringArgumentType> {
    @Override
    public void serializeToNetwork(StringArgumentType pArgument, FriendlyByteBuf pBuffer) {
        pBuffer.writeEnum((Enum<?>)pArgument.getType());
    }

    @Override
    public StringArgumentType deserializeFromNetwork(FriendlyByteBuf pBuffer) {
        StringArgumentType.StringType stringtype = pBuffer.readEnum(StringArgumentType.StringType.class);
        switch (stringtype) {
            case SINGLE_WORD: {
                return StringArgumentType.word();
            }
            case QUOTABLE_PHRASE: {
                return StringArgumentType.string();
            }
        }
        return StringArgumentType.greedyString();
    }

    @Override
    public void serializeToJson(StringArgumentType pArgument, JsonObject pJson) {
        switch (pArgument.getType()) {
            case SINGLE_WORD: {
                pJson.addProperty("type", "word");
                break;
            }
            case QUOTABLE_PHRASE: {
                pJson.addProperty("type", "phrase");
                break;
            }
            default: {
                pJson.addProperty("type", "greedy");
            }
        }
    }
}

