/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class DefaultedRegistry<T>
extends MappedRegistry<T> {
    private final ResourceLocation defaultKey;
    private Holder<T> defaultValue;

    public DefaultedRegistry(String p_205693_, ResourceKey<? extends Registry<T>> p_205694_, Lifecycle p_205695_, @Nullable Function<T, Holder.Reference<T>> p_205696_) {
        super(p_205694_, p_205695_, p_205696_);
        this.defaultKey = new ResourceLocation(p_205693_);
    }

    @Override
    public Holder<T> registerMapping(int pId, ResourceKey<T> pKey, T pValue, Lifecycle pLifecycle) {
        Holder<T> holder = super.registerMapping(pId, pKey, pValue, pLifecycle);
        if (this.defaultKey.equals(pKey.location())) {
            this.defaultValue = holder;
        }
        return holder;
    }

    @Override
    public int getId(@Nullable T pValue) {
        int i = super.getId(pValue);
        return i == -1 ? super.getId(this.defaultValue.value()) : i;
    }

    @Override
    @Nonnull
    public ResourceLocation getKey(T pValue) {
        ResourceLocation resourcelocation = super.getKey(pValue);
        return resourcelocation == null ? this.defaultKey : resourcelocation;
    }

    @Override
    @Nonnull
    public T get(@Nullable ResourceLocation pName) {
        Object t = super.get(pName);
        return t == null ? this.defaultValue.value() : t;
    }

    @Override
    public Optional<T> getOptional(@Nullable ResourceLocation pName) {
        return Optional.ofNullable(super.get(pName));
    }

    @Override
    @Nonnull
    public T byId(int pId) {
        Object t = super.byId(pId);
        return t == null ? this.defaultValue.value() : t;
    }

    @Override
    public Optional<Holder<T>> getRandom(Random pRandom) {
        return super.getRandom(pRandom).or(() -> Optional.of(this.defaultValue));
    }

    public ResourceLocation getDefaultKey() {
        return this.defaultKey;
    }
}

