/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final Codec<Direction> CODEC;
    public static final Codec<Direction> VERTICAL_CODEC;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    public static final Direction[] VALUES;
    private static final Map<String, Direction> BY_NAME;
    public static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;
    private static final Long2ObjectMap<Direction> BY_NORMAL;

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values, Direction::byName);
        VERTICAL_CODEC = CODEC.flatXmap(Direction::verifyVertical, Direction::verifyVertical);
        VALUES = Direction.values();
        BY_NAME = Arrays.stream(VALUES).collect(Collectors.toMap(Direction::getName, p_122425_0_ -> p_122425_0_));
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(p_122422_0_ -> p_122422_0_.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(p_122419_0_ -> p_122419_0_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(p_122414_0_ -> p_122414_0_.data2d)).toArray(Direction[]::new);
        BY_NORMAL = (Long2ObjectMap)Arrays.stream(VALUES).collect(Collectors.toMap(p_122409_0_ -> new BlockPos(p_122409_0_.getNormal()).asLong(), p_122393_0_ -> p_122393_0_, (p_122395_0_, p_122395_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    private Direction(int p_122356_, int p_122357_, int p_122358_, String p_122359_, AxisDirection p_122360_, Axis p_122361_, Vec3i p_122362_) {
        this.data3d = p_122356_;
        this.data2d = p_122358_;
        this.oppositeIndex = p_122357_;
        this.name = p_122359_;
        this.axis = p_122361_;
        this.axisDirection = p_122360_;
        this.normal = p_122362_;
    }

    public static Direction[] orderedByNearest(Entity pEntity) {
        Direction direction2;
        float f = pEntity.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float f1 = -pEntity.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float f2 = Mth.sin(f);
        float f3 = Mth.cos(f);
        float f4 = Mth.sin(f1);
        float f5 = Mth.cos(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.makeDirectionArray(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.makeDirectionArray(direction, direction2, direction1) : Direction.makeDirectionArray(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.makeDirectionArray(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.makeDirectionArray(direction2, direction, direction1) : Direction.makeDirectionArray(direction2, direction1, direction);
    }

    private static Direction[] makeDirectionArray(Direction pFirst, Direction pSecond, Direction pThird) {
        return new Direction[]{pFirst, pSecond, pThird, pThird.getOpposite(), pSecond.getOpposite(), pFirst.getOpposite()};
    }

    public static Direction rotate(Matrix4f pMatrix, Direction pDirection) {
        Vec3i vec3i = pDirection.getNormal();
        Vector4f vector4f = new Vector4f(vec3i.getX(), vec3i.getY(), vec3i.getZ(), 0.0f);
        vector4f.transform(pMatrix);
        return Direction.getNearest(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public Quaternion getRotation() {
        Quaternion quaternion = Vector3f.XP.rotationDegrees(90.0f);
        return switch (this) {
            case DOWN -> Vector3f.XP.rotationDegrees(180.0f);
            case UP -> Quaternion.ONE.copy();
            case NORTH -> {
                quaternion.mul(Vector3f.ZP.rotationDegrees(180.0f));
                yield quaternion;
            }
            case SOUTH -> quaternion;
            case WEST -> {
                quaternion.mul(Vector3f.ZP.rotationDegrees(90.0f));
                yield quaternion;
            }
            case EAST -> {
                quaternion.mul(Vector3f.ZP.rotationDegrees(-90.0f));
                yield quaternion;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static Direction getFacingAxis(Entity pEntity, Axis pAxis) {
        return switch (pAxis) {
            case Axis.X -> EAST.isFacingAngle(pEntity.getViewYRot(1.0f)) ? EAST : WEST;
            case Axis.Z -> SOUTH.isFacingAngle(pEntity.getViewYRot(1.0f)) ? SOUTH : NORTH;
            case Axis.Y -> pEntity.getViewXRot(1.0f) < 0.0f ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getOpposite() {
        return VALUES[this.oppositeIndex];
    }

    public Direction getClockWise(Axis p_175363_) {
        return switch (p_175363_) {
            case Axis.X -> this != WEST && this != EAST ? this.getClockWiseX() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.getClockWiseZ() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.getClockWise() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getCounterClockWise(Axis pAxis) {
        return switch (pAxis) {
            case Axis.X -> this != WEST && this != EAST ? this.getCounterClockWiseX() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.getCounterClockWiseZ() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.getCounterClockWise() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getClockWise() {
        return switch (this) {
            case NORTH -> EAST;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            case EAST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private Direction getClockWiseX() {
        return switch (this) {
            case DOWN -> SOUTH;
            case UP -> NORTH;
            case NORTH -> DOWN;
            case SOUTH -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction getCounterClockWiseX() {
        return switch (this) {
            case DOWN -> NORTH;
            case UP -> SOUTH;
            case NORTH -> UP;
            case SOUTH -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction getClockWiseZ() {
        return switch (this) {
            case DOWN -> WEST;
            case UP -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case WEST -> UP;
            case EAST -> DOWN;
        };
    }

    private Direction getCounterClockWiseZ() {
        return switch (this) {
            case DOWN -> EAST;
            case UP -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case WEST -> DOWN;
            case EAST -> UP;
        };
    }

    public Direction getCounterClockWise() {
        return switch (this) {
            case NORTH -> WEST;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            case EAST -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3f step() {
        return new Vector3f(this.getStepX(), this.getStepY(), this.getStepZ());
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static Direction byName(@Nullable String p_122403_) {
        return p_122403_ == null ? null : BY_NAME.get(p_122403_.toLowerCase(Locale.ROOT));
    }

    public static Direction from3DDataValue(int pIndex) {
        return BY_3D_DATA[Mth.abs(pIndex % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int pHorizontalIndex) {
        return BY_2D_DATA[Mth.abs(pHorizontalIndex % BY_2D_DATA.length)];
    }

    @Nullable
    public static Direction fromNormal(BlockPos pNormal) {
        return (Direction)BY_NORMAL.get(pNormal.asLong());
    }

    @Nullable
    public static Direction fromNormal(int pX, int pY, int pZ) {
        return (Direction)BY_NORMAL.get(BlockPos.asLong(pX, pY, pZ));
    }

    public static Direction fromYRot(double pAngle) {
        return Direction.from2DDataValue(Mth.floor(pAngle / 90.0 + 0.5) & 3);
    }

    public static Direction fromAxisAndDirection(Axis pAxis, AxisDirection pAxisDirection) {
        return switch (pAxis) {
            case Axis.X -> pAxisDirection == AxisDirection.POSITIVE ? EAST : WEST;
            case Axis.Z -> pAxisDirection == AxisDirection.POSITIVE ? SOUTH : NORTH;
            case Axis.Y -> pAxisDirection == AxisDirection.POSITIVE ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static Direction getRandom(Random pRandom) {
        return Util.a(VALUES, pRandom);
    }

    public static Direction getNearest(double pX, double p_122368_, double pY) {
        return Direction.getNearest((float)pX, (float)p_122368_, (float)pY);
    }

    public static Direction getNearest(float pX, float p_122374_, float pY) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        Direction[] directionArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction1 = directionArray[n2];
            float f1 = pX * (float)direction1.normal.getX() + p_122374_ * (float)direction1.normal.getY() + pY * (float)direction1.normal.getZ();
            if (f1 > f) {
                f = f1;
                direction = direction1;
            }
            ++n2;
        }
        return direction;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<Direction> verifyVertical(Direction p_194529_) {
        return p_194529_.getAxis().isVertical() ? DataResult.success((Object)p_194529_) : DataResult.error((String)"Expected a vertical direction");
    }

    public static Direction get(AxisDirection pAxisDirection, Axis pAxis) {
        Direction[] directionArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (direction.getAxisDirection() == pAxisDirection && direction.getAxis() == pAxis) {
                return direction;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)pAxisDirection) + " " + pAxis);
    }

    public Vec3i getNormal() {
        return this.normal;
    }

    public boolean isFacingAngle(float pDegrees) {
        float f = pDegrees * ((float)Math.PI / 180);
        float f1 = -Mth.sin(f);
        float f2 = Mth.cos(f);
        return (float)this.normal.getX() * f1 + (float)this.normal.getZ() * f2 > 0.0f;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int choose(int p_122496_, int p_122497_, int p_122498_) {
                return p_122496_;
            }

            @Override
            public double choose(double p_122492_, double p_122493_, double p_122494_) {
                return p_122492_;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int p_122510_, int p_122511_, int p_122512_) {
                return p_122511_;
            }

            @Override
            public double choose(double p_122506_, double p_122507_, double p_122508_) {
                return p_122507_;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int p_122524_, int p_122525_, int p_122526_) {
                return p_122526_;
            }

            @Override
            public double choose(double p_122520_, double p_122521_, double p_122522_) {
                return p_122522_;
            }
        };

        public static final Axis[] VALUES;
        public static final Codec<Axis> CODEC;
        private static final Map<String, Axis> BY_NAME;
        private final String name;

        static {
            VALUES = Axis.values();
            CODEC = StringRepresentable.fromEnum(Axis::values, Axis::byName);
            BY_NAME = Arrays.stream(VALUES).collect(Collectors.toMap(Axis::getName, p_122469_0_ -> p_122469_0_));
        }

        private Axis(String p_122456_) {
            this.name = p_122456_;
        }

        @Nullable
        public static Axis byName(String p_122474_) {
            return BY_NAME.get(p_122474_.toLowerCase(Locale.ROOT));
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandom(Random pRandom) {
            return Util.a(VALUES, pRandom);
        }

        @Override
        public boolean test(@Nullable Direction pDirection) {
            return pDirection != null && pDirection.getAxis() == this;
        }

        public Plane getPlane() {
            return switch (this) {
                case X, Z -> Plane.HORIZONTAL;
                case Y -> Plane.VERTICAL;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int p_122538_, String p_122539_) {
            this.step = p_122538_;
            this.name = p_122539_;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] faces;
        private final Axis[] axis;

        private Plane(Direction[] p_122555_, Axis[] p_122556_) {
            this.faces = p_122555_;
            this.axis = p_122556_;
        }

        public Direction getRandomDirection(Random pRandom) {
            return Util.a(this.faces, pRandom);
        }

        public Axis getRandomAxis(Random pRandom) {
            return Util.a(this.axis, pRandom);
        }

        @Override
        public boolean test(@Nullable Direction p_122559_) {
            return p_122559_ != null && p_122559_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<Direction> stream() {
            return Arrays.stream(this.faces);
        }
    }
}

