/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface Holder<T> {
    public T value();

    public boolean isBound();

    public boolean is(ResourceLocation var1);

    public boolean is(ResourceKey<T> var1);

    public boolean is(Predicate<ResourceKey<T>> var1);

    public boolean is(TagKey<T> var1);

    public Stream<TagKey<T>> tags();

    public Either<ResourceKey<T>, T> unwrap();

    public Optional<ResourceKey<T>> unwrapKey();

    public Kind kind();

    public boolean isValidInRegistry(Registry<T> var1);

    public static <T> Holder<T> direct(T p_205710_) {
        return new Direct<T>(p_205710_);
    }

    public static <T> Holder<T> hackyErase(Holder<? extends T> p_205707_) {
        return p_205707_;
    }

    public record Direct<T>(T value) implements Holder<T>
    {
        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public boolean is(ResourceLocation p_205727_) {
            return false;
        }

        @Override
        public boolean is(ResourceKey<T> p_205725_) {
            return false;
        }

        @Override
        public boolean is(TagKey<T> p_205719_) {
            return false;
        }

        @Override
        public boolean is(Predicate<ResourceKey<T>> p_205723_) {
            return false;
        }

        @Override
        public Either<ResourceKey<T>, T> unwrap() {
            return Either.right(this.value);
        }

        @Override
        public Optional<ResourceKey<T>> unwrapKey() {
            return Optional.empty();
        }

        @Override
        public Kind kind() {
            return Kind.DIRECT;
        }

        @Override
        public String toString() {
            return "Direct{" + this.value + "}";
        }

        @Override
        public boolean isValidInRegistry(Registry<T> p_205721_) {
            return true;
        }

        @Override
        public Stream<TagKey<T>> tags() {
            return Stream.of(new TagKey[0]);
        }
    }

    public static enum Kind {
        REFERENCE,
        DIRECT;

    }

    public static class Reference<T>
    implements Holder<T> {
        private final Registry<T> registry;
        private Set<TagKey<T>> tags = Set.of();
        private final Type type;
        @Nullable
        private ResourceKey<T> key;
        @Nullable
        private T value;

        private Reference(Type p_205754_, Registry<T> p_205755_, @Nullable ResourceKey<T> p_205756_, @Nullable T p_205757_) {
            this.registry = p_205755_;
            this.type = p_205754_;
            this.key = p_205756_;
            this.value = p_205757_;
        }

        public static <T> Reference<T> createStandAlone(Registry<T> p_205767_, ResourceKey<T> p_205768_) {
            return new Reference<Object>(Type.STAND_ALONE, p_205767_, p_205768_, null);
        }

        @Deprecated
        public static <T> Reference<T> createIntrusive(Registry<T> p_205764_, @Nullable T p_205765_) {
            return new Reference<T>(Type.INTRUSIVE, p_205764_, null, p_205765_);
        }

        public ResourceKey<T> key() {
            if (this.key == null) {
                throw new IllegalStateException("Trying to access unbound value '" + this.value + "' from registry " + this.registry);
            }
            return this.key;
        }

        @Override
        public T value() {
            if (this.value == null) {
                throw new IllegalStateException("Trying to access unbound value '" + this.key + "' from registry " + this.registry);
            }
            return this.value;
        }

        @Override
        public boolean is(ResourceLocation p_205779_) {
            return this.key().location().equals(p_205779_);
        }

        @Override
        public boolean is(ResourceKey<T> p_205774_) {
            return this.key() == p_205774_;
        }

        @Override
        public boolean is(TagKey<T> p_205760_) {
            return this.tags.contains(p_205760_);
        }

        @Override
        public boolean is(Predicate<ResourceKey<T>> p_205772_) {
            return p_205772_.test(this.key());
        }

        @Override
        public boolean isValidInRegistry(Registry<T> p_205762_) {
            return this.registry == p_205762_;
        }

        @Override
        public Either<ResourceKey<T>, T> unwrap() {
            return Either.left(this.key());
        }

        @Override
        public Optional<ResourceKey<T>> unwrapKey() {
            return Optional.of(this.key());
        }

        @Override
        public Kind kind() {
            return Kind.REFERENCE;
        }

        @Override
        public boolean isBound() {
            return this.key != null && this.value != null;
        }

        void bind(ResourceKey<T> p_205776_, T p_205777_) {
            if (this.key != null && p_205776_ != this.key) {
                throw new IllegalStateException("Can't change holder key: existing=" + this.key + ", new=" + p_205776_);
            }
            if (this.type == Type.INTRUSIVE && this.value != p_205777_) {
                throw new IllegalStateException("Can't change holder " + p_205776_ + " value: existing=" + this.value + ", new=" + p_205777_);
            }
            this.key = p_205776_;
            this.value = p_205777_;
        }

        void bindTags(Collection<TagKey<T>> p_205770_) {
            this.tags = Set.copyOf(p_205770_);
        }

        @Override
        public Stream<TagKey<T>> tags() {
            return this.tags.stream();
        }

        public String toString() {
            return "Reference{" + this.key + "=" + this.value + "}";
        }

        static enum Type {
            STAND_ALONE,
            INTRUSIVE;

        }
    }
}

