/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HolderSet<T>
extends Iterable<Holder<T>> {
    public Stream<Holder<T>> stream();

    public int size();

    public Either<TagKey<T>, List<Holder<T>>> unwrap();

    public Optional<Holder<T>> getRandomElement(Random var1);

    public Holder<T> get(int var1);

    public boolean contains(Holder<T> var1);

    public boolean isValidInRegistry(Registry<T> var1);

    @SafeVarargs
    public static <T> Direct<T> a(Holder<T> ... p_205810_) {
        return new Direct<T>(List.of(p_205810_));
    }

    public static <T> Direct<T> direct(List<? extends Holder<T>> p_205801_) {
        return new Direct(List.copyOf(p_205801_));
    }

    @SafeVarargs
    public static <E, T> Direct<T> a(Function<E, Holder<T>> p_205807_, E ... p_205808_) {
        return HolderSet.direct(Stream.of(p_205808_).map(p_205807_).toList());
    }

    public static <E, T> Direct<T> direct(Function<E, Holder<T>> p_205804_, List<E> p_205805_) {
        return HolderSet.direct(p_205805_.stream().map(p_205804_).toList());
    }

    public static class Direct<T>
    extends ListBacked<T> {
        private final List<Holder<T>> contents;
        @Nullable
        private Set<Holder<T>> contentsSet;

        Direct(List<Holder<T>> p_205814_) {
            this.contents = p_205814_;
        }

        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.right(this.contents);
        }

        @Override
        public boolean contains(Holder<T> p_205816_) {
            if (this.contentsSet == null) {
                this.contentsSet = Set.copyOf(this.contents);
            }
            return this.contentsSet.contains(p_205816_);
        }

        public String toString() {
            return "DirectSet[" + this.contents + "]";
        }
    }

    public static abstract class ListBacked<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> contents();

        @Override
        public int size() {
            return this.contents().size();
        }

        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.contents().spliterator();
        }

        @Override
        @NotNull
        public Iterator<Holder<T>> iterator() {
            return this.contents().iterator();
        }

        @Override
        public Stream<Holder<T>> stream() {
            return this.contents().stream();
        }

        @Override
        public Optional<Holder<T>> getRandomElement(Random p_205825_) {
            return Util.getRandomSafe(this.contents(), p_205825_);
        }

        @Override
        public Holder<T> get(int p_205823_) {
            return this.contents().get(p_205823_);
        }

        @Override
        public boolean isValidInRegistry(Registry<T> p_211043_) {
            return true;
        }
    }

    public static class Named<T>
    extends ListBacked<T> {
        private final Registry<T> registry;
        private final TagKey<T> key;
        private List<Holder<T>> contents = List.of();

        Named(Registry<T> p_211046_, TagKey<T> p_211047_) {
            this.registry = p_211046_;
            this.key = p_211047_;
        }

        void bind(List<Holder<T>> p_205836_) {
            this.contents = List.copyOf(p_205836_);
        }

        public TagKey<T> key() {
            return this.key;
        }

        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public boolean contains(Holder<T> p_205834_) {
            return p_205834_.is(this.key);
        }

        public String toString() {
            return "NamedSet(" + this.key + ")[" + this.contents + "]";
        }

        @Override
        public boolean isValidInRegistry(Registry<T> p_211049_) {
            return this.registry == p_211049_;
        }
    }
}

