/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.IdMap;

public class IdMapper<T>
implements IdMap<T> {
    private int nextId;
    private final Object2IntMap<T> tToId;
    private final List<T> idToT;

    public IdMapper() {
        this(512);
    }

    public IdMapper(int pExpectedSize) {
        this.idToT = Lists.newArrayListWithExpectedSize((int)pExpectedSize);
        this.tToId = new Object2IntOpenCustomHashMap(pExpectedSize, Util.identityStrategy());
        this.tToId.defaultReturnValue(-1);
    }

    public void addMapping(T pKey, int pValue) {
        this.tToId.put(pKey, pValue);
        while (this.idToT.size() <= pValue) {
            this.idToT.add(null);
        }
        this.idToT.set(pValue, pKey);
        if (this.nextId <= pValue) {
            this.nextId = pValue + 1;
        }
    }

    public void add(T pKey) {
        this.addMapping(pKey, this.nextId);
    }

    @Override
    public int getId(T pValue) {
        return this.tToId.getInt(pValue);
    }

    @Override
    @Nullable
    public final T byId(int pId) {
        return pId >= 0 && pId < this.idToT.size() ? (T)this.idToT.get(pId) : null;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter(this.idToT.iterator(), Objects::nonNull);
    }

    public boolean contains(int pId) {
        return this.byId(pId) != null;
    }

    @Override
    public int size() {
        return this.tToId.size();
    }
}

