/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class MappedRegistry<T>
extends WritableRegistry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)Util.make(new Object2IntOpenCustomHashMap(Util.identityStrategy()), p_194539_ -> p_194539_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<T, Lifecycle> lifecycles = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle elementsLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @Nullable
    private final Function<T, Holder.Reference<T>> customHolderProvider;
    @Nullable
    private Map<T, Holder.Reference<T>> intrusiveHolderCache;
    @Nullable
    private List<Holder.Reference<T>> holdersInOrder;
    private int nextId;

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_205849_, Lifecycle p_205850_, @Nullable Function<T, Holder.Reference<T>> p_205851_) {
        super(p_205849_, p_205850_);
        this.elementsLifecycle = p_205850_;
        this.customHolderProvider = p_205851_;
        if (p_205851_ != null) {
            this.intrusiveHolderCache = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    private List<Holder.Reference<T>> holdersInOrder() {
        if (this.holdersInOrder == null) {
            this.holdersInOrder = this.byId.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersInOrder;
    }

    private void validateWrite(ResourceKey<T> p_205922_) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + p_205922_ + ")");
        }
    }

    @Override
    public Holder<T> registerMapping(int pId, ResourceKey<T> pKey, T pValue, Lifecycle pLifecycle) {
        return this.registerMapping(pId, pKey, pValue, pLifecycle, true);
    }

    private Holder<T> registerMapping(int pId, ResourceKey<T> pKey, T pValue, Lifecycle pLifecycle, boolean pLogDuplicateKeys) {
        Holder.Reference reference;
        this.validateWrite(pKey);
        Validate.notNull(pKey);
        Validate.notNull(pValue);
        this.byId.size(Math.max(this.byId.size(), pId + 1));
        this.toId.put(pValue, pId);
        this.holdersInOrder = null;
        if (pLogDuplicateKeys && this.byKey.containsKey(pKey)) {
            Util.logAndPauseIfInIde("Adding duplicate key '" + pKey + "' to registry");
        }
        if (this.byValue.containsKey(pValue)) {
            Util.logAndPauseIfInIde("Adding duplicate value '" + pValue + "' to registry");
        }
        this.lifecycles.put(pValue, pLifecycle);
        this.elementsLifecycle = this.elementsLifecycle.add(pLifecycle);
        if (this.nextId <= pId) {
            this.nextId = pId + 1;
        }
        if (this.customHolderProvider != null) {
            reference = this.customHolderProvider.apply(pValue);
            Holder.Reference reference1 = this.byKey.put(pKey, reference);
            if (reference1 != null && reference1 != reference) {
                throw new IllegalStateException("Invalid holder present for key " + pKey);
            }
        } else {
            reference = this.byKey.computeIfAbsent(pKey, p_205927_ -> Holder.Reference.createStandAlone(this, p_205927_));
        }
        this.byLocation.put(pKey.location(), reference);
        this.byValue.put(pValue, reference);
        reference.bind(pKey, pValue);
        this.byId.set(pId, (Object)reference);
        return reference;
    }

    @Override
    public Holder<T> register(ResourceKey<T> pKey, T pValue, Lifecycle pLifecycle) {
        return this.registerMapping(this.nextId, pKey, pValue, pLifecycle);
    }

    @Override
    public Holder<T> registerOrOverride(OptionalInt pId, ResourceKey<T> pKey, T pValue, Lifecycle pLifecycle) {
        int i;
        Object t;
        this.validateWrite(pKey);
        Validate.notNull(pKey);
        Validate.notNull(pValue);
        Holder holder = this.byKey.get(pKey);
        Object v0 = t = holder != null && holder.isBound() ? holder.value() : null;
        if (t == null) {
            i = pId.orElse(this.nextId);
        } else {
            i = this.toId.getInt(t);
            if (pId.isPresent() && pId.getAsInt() != i) {
                throw new IllegalStateException("ID mismatch");
            }
            this.lifecycles.remove(t);
            this.toId.removeInt(t);
            this.byValue.remove(t);
        }
        return this.registerMapping(i, pKey, pValue, pLifecycle, false);
    }

    @Override
    @Nullable
    public ResourceLocation getKey(T pValue) {
        Holder.Reference<T> reference = this.byValue.get(pValue);
        return reference != null ? reference.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T pValue) {
        return Optional.ofNullable(this.byValue.get(pValue)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T pValue) {
        return this.toId.getInt(pValue);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> pKey) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(pKey));
    }

    @Override
    @Nullable
    public T byId(int pId) {
        return pId >= 0 && pId < this.byId.size() ? (T)MappedRegistry.getValueFromNullable((Holder.Reference)this.byId.get(pId)) : null;
    }

    @Override
    public Optional<Holder<T>> getHolder(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.byId.size() ? Optional.ofNullable((Holder)this.byId.get(p_205907_)) : Optional.empty();
    }

    @Override
    public Optional<Holder<T>> getHolder(ResourceKey<T> p_205905_) {
        return Optional.ofNullable((Holder)this.byKey.get(p_205905_));
    }

    @Override
    public Holder<T> getOrCreateHolder(ResourceKey<T> p_205913_) {
        return this.byKey.computeIfAbsent(p_205913_, p_205924_ -> {
            if (this.customHolderProvider != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)p_205924_);
            return Holder.Reference.createStandAlone(this, p_205924_);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Lifecycle lifecycle(T pValue) {
        return this.lifecycles.get(pValue);
    }

    @Override
    public Lifecycle elementsLifecycle() {
        return this.elementsLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.holdersInOrder().iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceLocation pKey) {
        Holder.Reference<T> reference = this.byLocation.get(pKey);
        return MappedRegistry.getValueFromNullable(reference);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.value() : null;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> holders() {
        return this.holdersInOrder().stream();
    }

    @Override
    public boolean isKnownTagName(TagKey<T> p_205864_) {
        return this.tags.containsKey(p_205864_);
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(p_211060_ -> Pair.of((Object)((TagKey)p_211060_.getKey()), (Object)((HolderSet.Named)p_211060_.getValue())));
    }

    @Override
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> p_205895_) {
        HolderSet.Named<T> named = this.tags.get(p_205895_);
        if (named == null) {
            named = this.createTag(p_205895_);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(p_205895_, named);
            this.tags = map;
        }
        return named;
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this, p_211068_);
    }

    @Override
    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder<T>> getRandom(Random pRandom) {
        return Util.getRandomSafe(this.holdersInOrder(), pRandom).map(Holder::hackyErase);
    }

    @Override
    public boolean containsKey(ResourceLocation pKey) {
        return this.byLocation.containsKey(pKey);
    }

    @Override
    public boolean containsKey(ResourceKey<T> pKey) {
        return this.byKey.containsKey(pKey);
    }

    @Override
    public Registry<T> freeze() {
        this.frozen = true;
        List<ResourceLocation> list = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).isBound()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).location()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.key() + ": " + list);
        }
        if (this.intrusiveHolderCache != null) {
            List<Holder.Reference> list1 = this.intrusiveHolderCache.values().stream().filter(p_211809_ -> !p_211809_.isBound()).toList();
            if (!list1.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not added to registry: " + list1);
            }
            this.intrusiveHolderCache = null;
        }
        return this;
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T p_205915_) {
        if (this.customHolderProvider == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        if (!this.frozen && this.intrusiveHolderCache != null) {
            return this.intrusiveHolderCache.computeIfAbsent(p_205915_, p_211813_ -> Holder.Reference.createIntrusive(this, p_211813_));
        }
        throw new IllegalStateException("Registry is already frozen");
    }

    @Override
    public Optional<HolderSet.Named<T>> getTag(TagKey<T> p_205909_) {
        return Optional.ofNullable(this.tags.get(p_205909_));
    }

    @Override
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> p_205875_) {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        p_205875_.forEach((? super K p_211806_, ? super V p_211807_) -> {
            for (Holder holder : p_211807_) {
                if (!holder.isValidInRegistry(this)) {
                    throw new IllegalStateException("Can't create named set " + p_211806_ + " containing value " + holder + " from outside registry " + this);
                }
                if (!(holder instanceof Holder.Reference)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + p_211806_);
                }
                Holder.Reference reference = (Holder.Reference)holder;
                ((List)map.get(reference)).add(p_211806_);
            }
        });
        Sets.SetView set = Sets.difference(this.tags.keySet(), p_205875_.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)set.stream().map(p_211811_ -> p_211811_.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map1 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        p_205875_.forEach((? super K p_211797_, ? super V p_211798_) -> map1.computeIfAbsent((TagKey<T>)p_211797_, this::createTag).bind(p_211798_));
        map.forEach(Holder.Reference::bindTags);
        this.tags = map1;
    }

    @Override
    public void resetTags() {
        this.tags.values().forEach(p_211792_ -> p_211792_.bind(List.of()));
        this.byKey.values().forEach(p_211803_ -> p_211803_.bindTags(Set.of()));
    }
}

