/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.slf4j.Logger;

public interface RegistryAccess {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<ResourceKey<? extends Registry<?>>, RegistryData<?>> REGISTRIES = (Map)Util.make(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryAccess.put(builder, Registry.DIMENSION_TYPE_REGISTRY, DimensionType.DIRECT_CODEC, DimensionType.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.BIOME_REGISTRY, Biome.DIRECT_CODEC, Biome.NETWORK_CODEC);
        RegistryAccess.put(builder, Registry.CONFIGURED_CARVER_REGISTRY, ConfiguredWorldCarver.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.CONFIGURED_FEATURE_REGISTRY, ConfiguredFeature.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.PLACED_FEATURE_REGISTRY, PlacedFeature.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, ConfiguredStructureFeature.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.STRUCTURE_SET_REGISTRY, StructureSet.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.PROCESSOR_LIST_REGISTRY, StructureProcessorType.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.TEMPLATE_POOL_REGISTRY, StructureTemplatePool.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.NOISE_GENERATOR_SETTINGS_REGISTRY, NoiseGeneratorSettings.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.NOISE_REGISTRY, NormalNoise.NoiseParameters.DIRECT_CODEC);
        RegistryAccess.put(builder, Registry.DENSITY_FUNCTION_REGISTRY, DensityFunction.DIRECT_CODEC);
        return builder.build();
    });
    public static final Codec<RegistryAccess> NETWORK_CODEC = RegistryAccess.makeNetworkCodec();
    public static final Supplier<Frozen> BUILTIN = Suppliers.memoize(() -> RegistryAccess.builtinCopy().freeze());

    public <E> Optional<Registry<E>> ownedRegistry(ResourceKey<? extends Registry<? extends E>> var1);

    default public <E> Registry<E> ownedRegistryOrThrow(ResourceKey<? extends Registry<? extends E>> pRegistryKey) {
        return this.ownedRegistry(pRegistryKey).orElseThrow(() -> new IllegalStateException("Missing registry: " + pRegistryKey));
    }

    default public <E> Optional<? extends Registry<E>> registry(ResourceKey<? extends Registry<? extends E>> pRegistryKey) {
        Optional<Registry<E>> optional = this.ownedRegistry(pRegistryKey);
        return optional.isPresent() ? optional : Registry.REGISTRY.getOptional(pRegistryKey.location());
    }

    default public <E> Registry<E> registryOrThrow(ResourceKey<? extends Registry<? extends E>> pRegistryKey) {
        return this.registry(pRegistryKey).orElseThrow(() -> new IllegalStateException("Missing registry: " + pRegistryKey));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, RegistryData<?>> pBuilder, ResourceKey<? extends Registry<E>> pRegistryKey, Codec<E> pElementCodec) {
        pBuilder.put(pRegistryKey, new RegistryData<E>(pRegistryKey, pElementCodec, null));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, RegistryData<?>> pBuilder, ResourceKey<? extends Registry<E>> pRegistryKey, Codec<E> pElementCodec, Codec<E> pNetworkCodec) {
        pBuilder.put(pRegistryKey, new RegistryData<E>(pRegistryKey, pElementCodec, pNetworkCodec));
    }

    public static Iterable<RegistryData<?>> knownRegistries() {
        return REGISTRIES.values();
    }

    public Stream<RegistryEntry<?>> ownedRegistries();

    private static Stream<RegistryEntry<Object>> globalRegistries() {
        return Registry.REGISTRY.holders().map(RegistryEntry::access$6);
    }

    default public Stream<RegistryEntry<?>> registries() {
        return Stream.concat(this.ownedRegistries(), RegistryAccess.globalRegistries());
    }

    default public Stream<RegistryEntry<?>> networkSafeRegistries() {
        return Stream.concat(this.ownedNetworkableRegistries(), RegistryAccess.globalRegistries());
    }

    private static <E> Codec<RegistryAccess> makeNetworkCodec() {
        Codec codec = ResourceLocation.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
        Codec codec1 = codec.partialDispatch("type", p_206188_ -> DataResult.success(p_206188_.key()), p_206214_ -> RegistryAccess.getNetworkCodec(p_206214_).map(p_206183_ -> RegistryCodecs.networkCodec(p_206214_, Lifecycle.experimental(), p_206183_)));
        UnboundedMapCodec unboundedmapcodec = Codec.unboundedMap((Codec)codec, (Codec)codec1);
        return RegistryAccess.captureMap(unboundedmapcodec);
    }

    private static <K extends ResourceKey<? extends Registry<?>>, V extends Registry<?>> Codec<RegistryAccess> captureMap(UnboundedMapCodec<K, V> p_206164_) {
        return p_206164_.xmap(ImmutableRegistryAccess::new, p_206180_ -> (Map)p_206180_.ownedNetworkableRegistries().collect(ImmutableMap.toImmutableMap(p_206195_ -> p_206195_.key(), p_206190_ -> p_206190_.value())));
    }

    private Stream<RegistryEntry<?>> ownedNetworkableRegistries() {
        return this.ownedRegistries().filter(p_206170_ -> REGISTRIES.get(p_206170_.key).sendToClient());
    }

    private static <E> DataResult<? extends Codec<E>> getNetworkCodec(ResourceKey<? extends Registry<E>> p_206204_) {
        return Optional.ofNullable(REGISTRIES.get(p_206204_)).map(p_206168_ -> p_206168_.networkCodec()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + p_206204_)));
    }

    private static Map<ResourceKey<? extends Registry<?>>, ? extends WritableRegistry<?>> createFreshRegistries() {
        return REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), RegistryAccess::createRegistry));
    }

    private static Writable blankWriteable() {
        return new WritableRegistryAccess(RegistryAccess.createFreshRegistries());
    }

    public static Frozen fromRegistryOfRegistries(Registry<? extends Registry<?>> p_206166_) {
        return new Frozen(){

            public <T> Optional<Registry<T>> ownedRegistry(ResourceKey<? extends Registry<? extends T>> p_206220_) {
                Registry registry = p_206166_;
                return registry.getOptional(p_206220_);
            }

            @Override
            public Stream<RegistryEntry<?>> ownedRegistries() {
                return p_206166_.entrySet().stream().map(RegistryEntry::access$5);
            }
        };
    }

    public static Writable builtinCopy() {
        Writable registryaccess$writable = RegistryAccess.blankWriteable();
        RegistryResourceAccess.InMemoryStorage registryresourceaccess$inmemorystorage = new RegistryResourceAccess.InMemoryStorage();
        for (Map.Entry<ResourceKey<Registry<?>>, RegistryData<?>> entry : REGISTRIES.entrySet()) {
            if (entry.getKey().equals(Registry.DIMENSION_TYPE_REGISTRY)) continue;
            RegistryAccess.addBuiltinElements(registryresourceaccess$inmemorystorage, entry.getValue());
        }
        RegistryOps.createAndLoad(JsonOps.INSTANCE, registryaccess$writable, registryresourceaccess$inmemorystorage);
        return DimensionType.registerBuiltin(registryaccess$writable);
    }

    private static <E> void addBuiltinElements(RegistryResourceAccess.InMemoryStorage p_211082_, RegistryData<E> p_211083_) {
        ResourceKey<Registry<E>> resourcekey = p_211083_.key();
        Registry<E> registry = BuiltinRegistries.ACCESS.registryOrThrow(resourcekey);
        for (Map.Entry<ResourceKey<E>, E> entry : registry.entrySet()) {
            ResourceKey<E> resourcekey1 = entry.getKey();
            E e = entry.getValue();
            p_211082_.add(BuiltinRegistries.ACCESS, resourcekey1, p_211083_.codec(), registry.getId(e), e, registry.lifecycle(e));
        }
    }

    public static void load(Writable p_206172_, DynamicOps<JsonElement> p_206173_, RegistryLoader p_206174_) {
        RegistryLoader.Bound registryloader$bound = p_206174_.bind(p_206172_);
        for (RegistryData<?> registrydata : REGISTRIES.values()) {
            RegistryAccess.readRegistry(p_206173_, registryloader$bound, registrydata);
        }
    }

    private static <E> void readRegistry(DynamicOps<JsonElement> pOps, RegistryLoader.Bound pDestinationRegistryAccess, RegistryData<E> pData) {
        DataResult<Registry<E>> dataresult = pDestinationRegistryAccess.overrideRegistryFromResources(pData.key(), pData.codec(), pOps);
        dataresult.error().ifPresent(p_206153_ -> {
            throw new JsonParseException("Error loading registry data: " + p_206153_.message());
        });
    }

    public static RegistryAccess readFromDisk(Dynamic<?> p_206155_) {
        return new ImmutableRegistryAccess(REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), p_206158_ -> RegistryAccess.retrieveRegistry(p_206158_, p_206155_))));
    }

    public static <E> Registry<E> retrieveRegistry(ResourceKey<? extends Registry<? extends E>> p_206185_, Dynamic<?> p_206186_) {
        return (Registry)RegistryOps.retrieveRegistry(p_206185_).codec().parse(p_206186_).resultOrPartial(Util.prefix(p_206185_ + " registry: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + p_206185_ + " registry"));
    }

    public static <E> WritableRegistry<?> createRegistry(ResourceKey<? extends Registry<?>> p_206201_) {
        return new MappedRegistry(p_206201_, Lifecycle.stable(), null);
    }

    default public Frozen freeze() {
        return new ImmutableRegistryAccess(this.ownedRegistries().map(RegistryEntry::access$7));
    }

    default public Lifecycle allElementsLifecycle() {
        return this.ownedRegistries().map(p_211815_ -> p_211815_.value.elementsLifecycle()).reduce(Lifecycle.stable(), Lifecycle::add);
    }

    public static interface Frozen
    extends RegistryAccess {
        @Override
        default public Frozen freeze() {
            return this;
        }
    }

    public static final class ImmutableRegistryAccess
    implements Frozen {
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> registries;

        public ImmutableRegistryAccess(Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> p_206225_) {
            this.registries = Map.copyOf(p_206225_);
        }

        ImmutableRegistryAccess(Stream<RegistryEntry<?>> p_206227_) {
            this.registries = (Map)p_206227_.collect(ImmutableMap.toImmutableMap(RegistryEntry::key, RegistryEntry::value));
        }

        @Override
        public <E> Optional<Registry<E>> ownedRegistry(ResourceKey<? extends Registry<? extends E>> p_206229_) {
            return Optional.ofNullable(this.registries.get(p_206229_)).map(p_206232_ -> p_206232_);
        }

        @Override
        public Stream<RegistryEntry<?>> ownedRegistries() {
            return this.registries.entrySet().stream().map(RegistryEntry::access$5);
        }
    }

    public record RegistryData<E>(ResourceKey<? extends Registry<E>> key, Codec<E> codec, @Nullable Codec<E> networkCodec) {
        public boolean sendToClient() {
            return this.networkCodec != null;
        }
    }

    public record RegistryEntry<T>(ResourceKey<? extends Registry<T>> key, Registry<T> value) {
        private static <T, R extends Registry<? extends T>> RegistryEntry<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends Registry<?>>, R> p_206242_) {
            return RegistryEntry.fromUntyped(p_206242_.getKey(), (Registry)p_206242_.getValue());
        }

        private static <T> RegistryEntry<T> fromHolder(Holder.Reference<? extends Registry<? extends T>> p_206240_) {
            return RegistryEntry.fromUntyped(p_206240_.key(), p_206240_.value());
        }

        private static <T> RegistryEntry<T> fromUntyped(ResourceKey<? extends Registry<?>> p_206244_, Registry<?> p_206245_) {
            return new RegistryEntry(p_206244_, p_206245_);
        }

        private RegistryEntry<T> freeze() {
            return new RegistryEntry<T>(this.key, this.value.freeze());
        }

        static /* synthetic */ RegistryEntry access$5(Map.Entry entry) {
            return RegistryEntry.fromMapEntry(entry);
        }

        static /* synthetic */ RegistryEntry access$6(Holder.Reference reference) {
            return RegistryEntry.fromHolder(reference);
        }

        static /* synthetic */ RegistryEntry access$7(RegistryEntry registryEntry) {
            return registryEntry.freeze();
        }
    }

    public static interface Writable
    extends RegistryAccess {
        public <E> Optional<WritableRegistry<E>> ownedWritableRegistry(ResourceKey<? extends Registry<? extends E>> var1);

        default public <E> WritableRegistry<E> ownedWritableRegistryOrThrow(ResourceKey<? extends Registry<? extends E>> p_206254_) {
            return this.ownedWritableRegistry(p_206254_).orElseThrow(() -> new IllegalStateException("Missing registry: " + p_206254_));
        }
    }

    public static final class WritableRegistryAccess
    implements Writable {
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends WritableRegistry<?>> registries;

        WritableRegistryAccess(Map<? extends ResourceKey<? extends Registry<?>>, ? extends WritableRegistry<?>> p_206259_) {
            this.registries = p_206259_;
        }

        @Override
        public <E> Optional<Registry<E>> ownedRegistry(ResourceKey<? extends Registry<? extends E>> p_206263_) {
            return Optional.ofNullable(this.registries.get(p_206263_)).map(p_206266_ -> p_206266_);
        }

        @Override
        public <E> Optional<WritableRegistry<E>> ownedWritableRegistry(ResourceKey<? extends Registry<? extends E>> p_206268_) {
            return Optional.ofNullable(this.registries.get(p_206268_)).map(p_206261_ -> p_206261_);
        }

        @Override
        public Stream<RegistryEntry<?>> ownedRegistries() {
            return this.registries.entrySet().stream().map(RegistryEntry::access$5);
        }
    }
}

