/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryCodecs {
    private static <T> MapCodec<RegistryEntry<T>> withNameAndId(ResourceKey<? extends Registry<T>> p_206304_, MapCodec<T> p_206305_) {
        return RecordCodecBuilder.mapCodec(p_206309_ -> p_206309_.group((App)ResourceLocation.CODEC.xmap(ResourceKey.elementKey(p_206304_), ResourceKey::location).fieldOf("name").forGetter(RegistryEntry::key), (App)Codec.INT.fieldOf("id").forGetter(RegistryEntry::id), (App)p_206305_.forGetter(RegistryEntry::value)).apply((Applicative)p_206309_, RegistryEntry::new));
    }

    public static <T> Codec<Registry<T>> networkCodec(ResourceKey<? extends Registry<T>> p_206292_, Lifecycle p_206293_, Codec<T> p_206294_) {
        return RegistryCodecs.withNameAndId(p_206292_, p_206294_.fieldOf("element")).codec().listOf().xmap(p_206298_ -> {
            MappedRegistry writableregistry = new MappedRegistry(p_206292_, p_206293_, null);
            for (RegistryEntry registryentry : p_206298_) {
                ((WritableRegistry)writableregistry).registerMapping(registryentry.id(), registryentry.key(), registryentry.value(), p_206293_);
            }
            return writableregistry;
        }, p_206314_ -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object t : p_206314_) {
                builder.add(new RegistryEntry(p_206314_.getResourceKey(t).get(), p_206314_.getId(t), t));
            }
            return builder.build();
        });
    }

    public static <E> Codec<Registry<E>> dataPackAwareCodec(ResourceKey<? extends Registry<E>> p_206319_, Lifecycle p_206320_, Codec<E> p_206321_) {
        Codec<Map<ResourceKey<E>, E>> codec = RegistryCodecs.directCodec(p_206319_, p_206321_);
        Encoder encoder = codec.comap(p_206271_ -> ImmutableMap.copyOf(p_206271_.entrySet()));
        return Codec.of((Encoder)encoder, RegistryCodecs.dataPackAwareDecoder(p_206319_, p_206321_, codec, p_206320_), (String)("DataPackRegistryCodec for " + p_206319_));
    }

    private static <E> Decoder<Registry<E>> dataPackAwareDecoder(ResourceKey<? extends Registry<E>> p_206283_, Codec<E> p_206284_, Decoder<Map<ResourceKey<E>, E>> p_206285_, Lifecycle p_206286_) {
        Decoder decoder = p_206285_.map(p_206302_ -> {
            MappedRegistry writableregistry = new MappedRegistry(p_206283_, p_206286_, null);
            p_206302_.forEach((p_206275_, p_206276_) -> writableregistry.register(p_206275_, p_206276_, p_206286_));
            return writableregistry;
        });
        return new Decoder<Registry<E>>(){

            public <T> DataResult<Pair<Registry<E>, T>> decode(DynamicOps<T> p_206352_, T p_206353_) {
                DataResult dataresult = decoder.decode(p_206352_, p_206353_);
                if (p_206352_ instanceof RegistryOps) {
                    RegistryOps registryops = (RegistryOps)p_206352_;
                    return registryops.registryLoader().map(p_206338_ -> this.overrideFromResources(dataresult, registryops, p_206338_.loader())).orElseGet(() -> DataResult.error((String)"Can't load registry with this ops"));
                }
                return dataresult.map(p_206331_ -> p_206331_.mapFirst(p_206344_ -> p_206344_));
            }

            private <T> DataResult<Pair<Registry<E>, T>> overrideFromResources(DataResult<Pair<WritableRegistry<E>, T>> p_206340_, RegistryOps<?> p_206341_, RegistryLoader p_206342_) {
                return p_206340_.flatMap(p_206350_ -> p_206342_.overrideRegistryFromResources((WritableRegistry)p_206350_.getFirst(), p_206283_, p_206284_, p_206341_.getAsJson()).map(p_206334_ -> Pair.of((Object)p_206334_, (Object)p_206350_.getSecond())));
            }
        };
    }

    private static <T> Codec<Map<ResourceKey<T>, T>> directCodec(ResourceKey<? extends Registry<T>> p_206316_, Codec<T> p_206317_) {
        return Codec.unboundedMap((Codec)ResourceLocation.CODEC.xmap(ResourceKey.elementKey(p_206316_), ResourceKey::location), p_206317_);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> p_206280_, Codec<E> p_206281_) {
        return RegistryCodecs.homogeneousList(p_206280_, p_206281_, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> p_206288_, Codec<E> p_206289_, boolean p_206290_) {
        return HolderSetCodec.create(p_206288_, RegistryFileCodec.create(p_206288_, p_206289_), p_206290_);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> p_206278_) {
        return RegistryCodecs.homogeneousList(p_206278_, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> p_206311_, boolean p_206312_) {
        return HolderSetCodec.create(p_206311_, RegistryFixedCodec.create(p_206311_), p_206312_);
    }

    record RegistryEntry<T>(ResourceKey<T> key, int id, T value) {
    }
}

