/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.Util;

public final class SerializableUUID {
    public static final Codec<UUID> CODEC = Codec.INT_STREAM.comapFlatMap(p_123280_ -> Util.fixedSize(p_123280_, 4).map(SerializableUUID::a), p_123284_ -> Arrays.stream(SerializableUUID.uuidToIntArray(p_123284_)));

    private SerializableUUID() {
    }

    public static UUID a(int[] p_123282_) {
        return new UUID((long)p_123282_[0] << 32 | (long)p_123282_[1] & 0xFFFFFFFFL, (long)p_123282_[2] << 32 | (long)p_123282_[3] & 0xFFFFFFFFL);
    }

    public static int[] uuidToIntArray(UUID pUuid) {
        long i = pUuid.getMostSignificantBits();
        long j = pUuid.getLeastSignificantBits();
        return SerializableUUID.leastMostToIntArray(i, j);
    }

    private static int[] leastMostToIntArray(long pMost, long p_123276_) {
        return new int[]{(int)(pMost >> 32), (int)pMost, (int)(p_123276_ >> 32), (int)p_123276_};
    }

    public static UUID readUUID(Dynamic<?> pDynamic) {
        int[] aint = pDynamic.asIntStream().toArray();
        if (aint.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + aint.length + ".");
        }
        return SerializableUUID.a(aint);
    }
}

