/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    @Override
    protected ItemStack execute(BlockSource pSource, ItemStack pStack) {
        ServerLevel level = pSource.getLevel();
        if (!level.isClientSide()) {
            BlockPos blockpos = pSource.getPos().relative(pSource.getBlockState().getValue(DispenserBlock.FACING));
            this.setSuccess(ShearsDispenseItemBehavior.tryShearBeehive(level, blockpos) || ShearsDispenseItemBehavior.tryShearLivingEntity(level, blockpos));
            if (this.isSuccess() && pStack.hurt(1, level.getRandom(), null)) {
                pStack.setCount(0);
            }
        }
        return pStack;
    }

    private static boolean tryShearBeehive(ServerLevel pLevel, BlockPos pPos) {
        int i;
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.is(BlockTags.BEEHIVES, p_202454_ -> p_202454_.hasProperty(BeehiveBlock.HONEY_LEVEL) && p_202454_.getBlock() instanceof BeehiveBlock) && (i = blockstate.getValue(BeehiveBlock.HONEY_LEVEL).intValue()) >= 5) {
            pLevel.playSound(null, pPos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb(pLevel, pPos);
            ((BeehiveBlock)blockstate.getBlock()).releaseBeesAndResetHoneyLevel(pLevel, blockstate, pPos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            pLevel.gameEvent(null, GameEvent.SHEAR, pPos);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(ServerLevel pLevel, BlockPos pPos) {
        for (LivingEntity livingEntity : pLevel.getEntitiesOfClass(LivingEntity.class, new AABB(pPos), EntitySelector.NO_SPECTATORS)) {
            Shearable shearable;
            if (!(livingEntity instanceof Shearable) || !(shearable = (Shearable)((Object)livingEntity)).readyForShearing()) continue;
            shearable.shear(SoundSource.BLOCKS);
            pLevel.gameEvent(null, GameEvent.SHEAR, pPos);
            return true;
        }
        return false;
    }
}

