/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class DustParticleOptions
extends DustParticleOptionsBase {
    public static final Vector3f REDSTONE_PARTICLE_COLOR = new Vector3f(Vec3.fromRGB24(0xFF0000));
    public static final DustParticleOptions REDSTONE = new DustParticleOptions(REDSTONE_PARTICLE_COLOR, 1.0f);
    public static final Codec<DustParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)Vector3f.CODEC.fieldOf("color").forGetter(p_175797_ -> p_175797_.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_175795_ -> Float.valueOf(p_175795_.scale))).apply((Applicative)p_175793_, DustParticleOptions::new));
    public static final ParticleOptions.Deserializer<DustParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<DustParticleOptions>(){

        @Override
        public DustParticleOptions fromCommand(ParticleType<DustParticleOptions> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            Vector3f vector3f = DustParticleOptionsBase.readVector3f(p_123690_);
            p_123690_.expect(' ');
            float f = p_123690_.readFloat();
            return new DustParticleOptions(vector3f, f);
        }

        @Override
        public DustParticleOptions fromNetwork(ParticleType<DustParticleOptions> p_123692_, FriendlyByteBuf p_123693_) {
            return new DustParticleOptions(DustParticleOptionsBase.readVector3f(p_123693_), p_123693_.readFloat());
        }
    };

    public DustParticleOptions(Vector3f p_175790_, float p_175791_) {
        super(p_175790_, p_175791_);
    }

    public ParticleType<DustParticleOptions> getType() {
        return ParticleTypes.DUST;
    }
}

