/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class BlockFamily {
    private final Block baseBlock;
    final Map<Variant, Block> variants = Maps.newHashMap();
    boolean generateModel = true;
    boolean generateRecipe = true;
    @Nullable
    String recipeGroupPrefix;
    @Nullable
    String recipeUnlockedBy;

    BlockFamily(Block pBaseBlock) {
        this.baseBlock = pBaseBlock;
    }

    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public Map<Variant, Block> getVariants() {
        return this.variants;
    }

    public Block get(Variant pVariant) {
        return this.variants.get((Object)pVariant);
    }

    public boolean shouldGenerateModel() {
        return this.generateModel;
    }

    public boolean shouldGenerateRecipe() {
        return this.generateRecipe;
    }

    public Optional<String> getRecipeGroupPrefix() {
        return StringUtils.isBlank((CharSequence)this.recipeGroupPrefix) ? Optional.empty() : Optional.of(this.recipeGroupPrefix);
    }

    public Optional<String> getRecipeUnlockedBy() {
        return StringUtils.isBlank((CharSequence)this.recipeUnlockedBy) ? Optional.empty() : Optional.of(this.recipeUnlockedBy);
    }

    public static class Builder {
        private final BlockFamily family;

        public Builder(Block pBaseBlock) {
            this.family = new BlockFamily(pBaseBlock);
        }

        public BlockFamily getFamily() {
            return this.family;
        }

        public Builder button(Block pButtonBlock) {
            this.family.variants.put(Variant.BUTTON, pButtonBlock);
            return this;
        }

        public Builder chiseled(Block pChiseledBlock) {
            this.family.variants.put(Variant.CHISELED, pChiseledBlock);
            return this;
        }

        public Builder cracked(Block pCrackedBlock) {
            this.family.variants.put(Variant.CRACKED, pCrackedBlock);
            return this;
        }

        public Builder cut(Block pCutBlock) {
            this.family.variants.put(Variant.CUT, pCutBlock);
            return this;
        }

        public Builder door(Block pDoorBlock) {
            this.family.variants.put(Variant.DOOR, pDoorBlock);
            return this;
        }

        public Builder fence(Block pFenceBlock) {
            this.family.variants.put(Variant.FENCE, pFenceBlock);
            return this;
        }

        public Builder fenceGate(Block pFenceGateBlock) {
            this.family.variants.put(Variant.FENCE_GATE, pFenceGateBlock);
            return this;
        }

        public Builder sign(Block pSignBlock, Block pWallSignBlock) {
            this.family.variants.put(Variant.SIGN, pSignBlock);
            this.family.variants.put(Variant.WALL_SIGN, pWallSignBlock);
            return this;
        }

        public Builder slab(Block pSlabBlock) {
            this.family.variants.put(Variant.SLAB, pSlabBlock);
            return this;
        }

        public Builder stairs(Block pStairsBlock) {
            this.family.variants.put(Variant.STAIRS, pStairsBlock);
            return this;
        }

        public Builder pressurePlate(Block pPressurePlateBlock) {
            this.family.variants.put(Variant.PRESSURE_PLATE, pPressurePlateBlock);
            return this;
        }

        public Builder polished(Block pPolishedBlock) {
            this.family.variants.put(Variant.POLISHED, pPolishedBlock);
            return this;
        }

        public Builder trapdoor(Block pTrapdoorBlock) {
            this.family.variants.put(Variant.TRAPDOOR, pTrapdoorBlock);
            return this;
        }

        public Builder wall(Block pWallBlock) {
            this.family.variants.put(Variant.WALL, pWallBlock);
            return this;
        }

        public Builder dontGenerateModel() {
            this.family.generateModel = false;
            return this;
        }

        public Builder dontGenerateRecipe() {
            this.family.generateRecipe = false;
            return this;
        }

        public Builder recipeGroupPrefix(String pRecipeGroupPrefix) {
            this.family.recipeGroupPrefix = pRecipeGroupPrefix;
            return this;
        }

        public Builder recipeUnlockedBy(String pRecipeUnlockedBy) {
            this.family.recipeUnlockedBy = pRecipeUnlockedBy;
            return this;
        }
    }

    public static enum Variant {
        BUTTON("button"),
        CHISELED("chiseled"),
        CRACKED("cracked"),
        CUT("cut"),
        DOOR("door"),
        FENCE("fence"),
        FENCE_GATE("fence_gate"),
        SIGN("sign"),
        SLAB("slab"),
        STAIRS("stairs"),
        PRESSURE_PLATE("pressure_plate"),
        POLISHED("polished"),
        TRAPDOOR("trapdoor"),
        WALL("wall"),
        WALL_SIGN("wall_sign");

        private final String name;

        private Variant(String p_176019_) {
            this.name = p_176019_;
        }

        public String getName() {
            return this.name;
        }
    }
}

