/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.HashCache;

public interface DataProvider {
    public static final HashFunction SHA1 = Hashing.sha1();

    public void run(HashCache var1) throws IOException;

    public String getName();

    public static void save(Gson pGson, HashCache pCache, JsonElement pJsonElement, Path pPath) throws IOException {
        String s = pGson.toJson(pJsonElement);
        String s1 = SHA1.hashUnencodedChars((CharSequence)s).toString();
        if (!Objects.equals(pCache.getHash(pPath), s1) || !Files.exists(pPath, new LinkOption[0])) {
            Files.createDirectories(pPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pPath, new OpenOption[0]);){
                bufferedwriter.write(s);
            }
        }
        pCache.putNew(pPath, s1);
    }
}

