/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.advancements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdventureAdvancements;
import net.minecraft.data.advancements.HusbandryAdvancements;
import net.minecraft.data.advancements.NetherAdvancements;
import net.minecraft.data.advancements.StoryAdvancements;
import net.minecraft.data.advancements.TheEndAdvancements;
import org.slf4j.Logger;

public class AdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final List<Consumer<Consumer<Advancement>>> tabs = ImmutableList.of((Object)new TheEndAdvancements(), (Object)new HusbandryAdvancements(), (Object)new AdventureAdvancements(), (Object)new NetherAdvancements(), (Object)new StoryAdvancements());

    public AdvancementProvider(DataGenerator pGenerator) {
        this.generator = pGenerator;
    }

    @Override
    public void run(HashCache pCache) {
        Path path = this.generator.getOutputFolder();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_123977_ -> {
            if (!set.add(p_123977_.getId())) {
                throw new IllegalStateException("Duplicate advancement " + p_123977_.getId());
            }
            Path path1 = AdvancementProvider.createPath(path, p_123977_);
            try {
                DataProvider.save(GSON, pCache, (JsonElement)p_123977_.deconstruct().serializeToJson(), path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        for (Consumer<Consumer<Advancement>> consumer1 : this.tabs) {
            consumer1.accept(consumer);
        }
    }

    private static Path createPath(Path pPath, Advancement pAdvancement) {
        return pPath.resolve("data/" + pAdvancement.getId().getNamespace() + "/advancements/" + pAdvancement.getId().getPath() + ".json");
    }

    @Override
    public String getName() {
        return "Advancements";
    }
}

