/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class ModelProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    public ModelProvider(DataGenerator pGenerator) {
        this.generator = pGenerator;
    }

    @Override
    public void run(HashCache pCache) {
        Path path = this.generator.getOutputFolder();
        HashMap map = Maps.newHashMap();
        Consumer<BlockStateGenerator> consumer = p_125120_ -> {
            Block block = p_125120_.getBlock();
            BlockStateGenerator blockstategenerator = map.put(block, p_125120_);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap map1 = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> biconsumer = (p_125123_, p_125124_) -> {
            Supplier supplier = map1.put(p_125123_, p_125124_);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + p_125123_);
            }
        };
        Consumer<Item> consumer1 = set::add;
        new BlockModelGenerators(consumer, biconsumer, consumer1).run();
        new ItemModelGenerators(biconsumer).run();
        List list = Registry.BLOCK.stream().filter(p_125117_ -> !map.containsKey(p_125117_)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + list);
        }
        Registry.BLOCK.forEach(p_125128_ -> {
            Item item = Item.BY_BLOCK.get(p_125128_);
            if (item != null) {
                if (set.contains(item)) {
                    return;
                }
                ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation(item);
                if (!map1.containsKey(resourcelocation)) {
                    map1.put(resourcelocation, new DelegatedModel(ModelLocationUtils.getModelLocation(p_125128_)));
                }
            }
        });
        this.saveCollection(pCache, path, map, ModelProvider::createBlockStatePath);
        this.saveCollection(pCache, path, map1, ModelProvider::createModelPath);
    }

    private <T> void saveCollection(HashCache pCache, Path pRootPath, Map<T, ? extends Supplier<JsonElement>> pObjectToJsonMap, BiFunction<Path, T, Path> pResolveObjectPath) {
        pObjectToJsonMap.forEach((p_125133_, p_125134_) -> {
            Path path2 = (Path)pResolveObjectPath.apply(pRootPath, p_125133_);
            try {
                DataProvider.save(GSON, pCache, (JsonElement)p_125134_.get(), path2);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't save {}", (Object)path2, (Object)exception);
            }
        });
    }

    private static Path createBlockStatePath(Path p_125110_, Block p_125111_) {
        ResourceLocation resourcelocation = Registry.BLOCK.getKey(p_125111_);
        return p_125110_.resolve("assets/" + resourcelocation.getNamespace() + "/blockstates/" + resourcelocation.getPath() + ".json");
    }

    private static Path createModelPath(Path p_125113_, ResourceLocation p_125114_) {
        return p_125113_.resolve("assets/" + p_125114_.getNamespace() + "/models/" + p_125114_.getPath() + ".json");
    }

    @Override
    public String getName() {
        return "Block State Definitions";
    }
}

