/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class MultiPartGenerator
implements BlockStateGenerator {
    private final Block block;
    private final List<Entry> parts = Lists.newArrayList();

    private MultiPartGenerator(Block pBlock) {
        this.block = pBlock;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public static MultiPartGenerator multiPart(Block pBlock) {
        return new MultiPartGenerator(pBlock);
    }

    public MultiPartGenerator with(List<Variant> pVariants) {
        this.parts.add(new Entry(pVariants));
        return this;
    }

    public MultiPartGenerator with(Variant pVariants) {
        return this.with((List<Variant>)ImmutableList.of((Object)pVariants));
    }

    public MultiPartGenerator with(Condition pCondition, List<Variant> pVariants) {
        this.parts.add(new ConditionalEntry(pCondition, pVariants));
        return this;
    }

    public MultiPartGenerator a(Condition p_125216_, Variant ... p_125217_) {
        return this.with(p_125216_, (List<Variant>)ImmutableList.copyOf((Object[])p_125217_));
    }

    public MultiPartGenerator with(Condition pCondition, Variant pVariants) {
        return this.with(pCondition, (List<Variant>)ImmutableList.of((Object)pVariants));
    }

    @Override
    public JsonElement get() {
        StateDefinition<Block, BlockState> statedefinition = this.block.getStateDefinition();
        this.parts.forEach(p_125208_ -> p_125208_.validate(statedefinition));
        JsonArray jsonarray = new JsonArray();
        this.parts.stream().map(Entry::get).forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("multipart", (JsonElement)jsonarray);
        return jsonobject;
    }

    static class ConditionalEntry
    extends Entry {
        private final Condition condition;

        ConditionalEntry(Condition pCondition, List<Variant> pVariants) {
            super(pVariants);
            this.condition = pCondition;
        }

        @Override
        public void validate(StateDefinition<?, ?> pStateDefinition) {
            this.condition.validate(pStateDefinition);
        }

        @Override
        public void decorate(JsonObject pJsonObject) {
            pJsonObject.add("when", (JsonElement)this.condition.get());
        }
    }

    static class Entry
    implements Supplier<JsonElement> {
        private final List<Variant> variants;

        Entry(List<Variant> pVariants) {
            this.variants = pVariants;
        }

        public void validate(StateDefinition<?, ?> pStateDefinition) {
        }

        public void decorate(JsonObject pJsonObject) {
        }

        @Override
        public JsonElement get() {
            JsonObject jsonobject = new JsonObject();
            this.decorate(jsonobject);
            jsonobject.add("apply", Variant.convertList(this.variants));
            return jsonobject;
        }
    }
}

